<?php

/********************
 * 
 *   Pagination
 *
 ********************/

/**
 * @param WP_Query|null $wp_query
 * @param bool $echo
 * @param array $params
 *
 * @return string|null
 * 
 * Accepts a WP_Query instance to build pagination (for custom wp_query()),
 * or nothing to use the current global $wp_query (eg: taxonomy term page)
 * - Tested on WP 5.4.1
 * - Tested with Bootstrap 4.4
 * - Tested on Sage 9.0.9
 *
 * INSTALLATION:
 * add this file content to your theme function.php or equivalent
 *
 * USAGE:
 *     <?php echo bootstrap_pagination(); ?> //uses global $wp_query
 * or with custom WP_Query():
 *     <?php
 *      $query = new \WP_Query($args);
 *       ... while(have_posts()), $query->posts stuff ... endwhile() ...
 *       echo bootstrap_pagination($query);
 *     ?>
 */
//function bootstrap_pagination($wp_query = null, $echo = true, $params = [], $use_alt = null)
function bootstrap_pagination($wp_query = null, $echo = true, $params = [])
{
    if (null === $wp_query) {
        global $wp_query;
    }

    $add_args = [];

    /* if ( $use_alt ) {
        $add_args['pgs'] = $GLOBALS['wp_query']->max_num_pages;
    } */

    if ( is_rtl() ){
        $prev_text = __('»');
        $next_text = __('«');
    }else{
        $prev_text = __('«');
        $next_text = __('»');
    }


    $big = 999999999; // need an unlikely integer

    $pages = paginate_links(
        array_merge([
            'base'         => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
            'format'       => '?paged=%#%',
            //'current'      => max( 1, get_query_var( $use_alt ? 'pg' : 'paged' ) ),
			'current'      => max(1, get_query_var('paged')),
            'total'        => $wp_query->max_num_pages,
            'type'         => 'array',
            'show_all'     => false,
            'end_size'     => 3,
            'mid_size'     => 1,
            'prev_next'    => true,
            'prev_text'    => $prev_text,
            'next_text'    => $next_text,
            'add_args'     => $add_args,
            'add_fragment' => ''
        ], $params)
    );

    if (is_array($pages)) {
        //$current_page = ( get_query_var( 'paged' ) == 0 ) ? 1 : get_query_var( 'paged' );
        $pagination = '<div class="pagination"><ul class="pagination">';

        foreach ($pages as $page) {
            $pagination .= '<li class="page-item' . (strpos($page, 'current') !== false ? ' active' : '') . '"> ' . str_replace('page-numbers', 'page-link', $page) . '</li>';
        }

        $pagination .= '</ul></div>';

        if ($echo) {
            echo $pagination;
        } else {
            return $pagination;
        }
    }

    return null;
}

/*================*/

function bootstrap_term_pagination($term,$per_page, $echo = true, $params = [])
{

    $total_terms   = wp_count_terms( $term ); 

    $total_pages   = ceil( $total_terms / $per_page );

    $add_args = [];


    if ( is_rtl() ){
        $prev_text = __('»');
        $next_text = __('«');
    }else{
        $prev_text = __('«');
        $next_text = __('»');
    }

    $big = 999999999; // need an unlikely integer

    $pages = paginate_links(
        array_merge([
            'base'         => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
            'format'       => '?paged=%#%',
			'current'      => max(1, get_query_var('paged')),
            'total'        => $total_pages,
            'type'         => 'array',
            'show_all'     => false,
            'end_size'     => 3,
            'mid_size'     => 1,
            'prev_next'    => true,
            'prev_text'    => $prev_text,
            'next_text'    => $next_text,
            'add_args'     => $add_args,
            'add_fragment' => ''
        ], $params)
    );

    if (is_array($pages)) {
        //$current_page = ( get_query_var( 'paged' ) == 0 ) ? 1 : get_query_var( 'paged' );
        $pagination = '<div class="pagination"><ul class="pagination">';

        foreach ($pages as $page) {
            $pagination .= '<li class="page-item' . (strpos($page, 'current') !== false ? ' active' : '') . '"> ' . str_replace('page-numbers', 'page-link', $page) . '</li>';
        }

        $pagination .= '</ul></div>';

        if ($echo) {
            echo $pagination;
        } else {
            return $pagination;
        }
    }

    return null;
}
