<?php

function sam_add_social_accounts_page()
{
    add_menu_page(
        'Social Accounts', // page title
        'Social Accounts', // menu title
        'manage_options', // capability to access the page
        'sam-social-accounts-settings', // menu slug
        'sam_social_accounts_content', // callback function
        'dashicons-layout', // menu icon
        //5 // position
    );
}

add_action('admin_menu', 'sam_add_social_accounts_page');



function sam_social_accounts_content()
{
   ?>
   <h2>Social Accounts</h2>
   <form action="options.php" method="post">
   <?php 
    settings_fields('sam_social_accounts_settings');
    do_settings_sections('sam-social-accounts-settings');
    submit_button();
    ?>
    </form>
<?php 
}


function sam_social_accounts_register_settings()
{
    add_settings_section(
		'sam_social_accounts_section', // section ID
		'Social Accounts', // title
		'', // callback function
		'sam-social-accounts-settings' // page slug
	);

    /*===========
    * Fields
    ============*/
    /* Facebook */
	add_settings_field(
		'sam_social_accounts_facebook',
		'Facebook',
		'sam_social_accounts_facebook_field_html', // function which prints the field
		'sam-social-accounts-settings', // page slug
		'sam_social_accounts_section', // section ID
		array( 
			'label_for' => 'sam_social_accounts_facebook',
			'class' => 'banner-text',
		)
	);
    register_setting(
		'sam_social_accounts_settings', // settings group name
		'sam_social_accounts_facebook', // field name
		'sanitize_text_field' // sanitization function
	);

    /* Instagram */
	add_settings_field(
		'sam_social_accounts_instagram',
		'Instagram',
		'sam_social_accounts_instagram_field_html', // function which prints the field
		'sam-social-accounts-settings', // page slug
		'sam_social_accounts_section', // section ID
		array( 
			'label_for' => 'sam_social_accounts_instagram',
			'class' => 'banner-text',
		)
	);
    register_setting(
		'sam_social_accounts_settings', // settings group name
		'sam_social_accounts_instagram', // field name
		'sanitize_text_field' // sanitization function
	);


    /* Youtube */
    add_settings_field(
		'sam_social_accounts_youtube',
		'Youtube',
		'sam_social_accounts_youtube_field_html', // function which prints the field
		'sam-social-accounts-settings', // page slug
		'sam_social_accounts_section', // section ID
		array( 
			'label_for' => 'sam_social_accounts_youtube',
			'class' => 'banner-text',
		)
	);
    register_setting(
		'sam_social_accounts_settings', // settings group name
		'sam_social_accounts_youtube', // field name
		'sanitize_text_field' // sanitization function
	);
	
    /* Youtube */
    add_settings_field(
		'sam_social_accounts_youtube',
		'Youtube',
		'sam_social_accounts_youtube_field_html', // function which prints the field
		'sam-social-accounts-settings', // page slug
		'sam_social_accounts_section', // section ID
		array( 
			'label_for' => 'sam_social_accounts_youtube',
			'class' => 'banner-text',
		)
	);
    register_setting(
		'sam_social_accounts_settings', // settings group name
		'sam_social_accounts_youtube', // field name
		'sanitize_text_field' // sanitization function
	);

    /* Whatsapp */
	add_settings_field(
		'sam_social_accounts_whatsapp',
		'Whatsapp',
		'sam_social_accounts_whatsapp_field_html', // function which prints the field
		'sam-social-accounts-settings', // page slug
		'sam_social_accounts_section', // section ID
		array( 
			'label_for' => 'sam_social_accounts_whatsapp',
			'class' => 'banner-text',
		)
	);
    register_setting(
		'sam_social_accounts_settings', // settings group name
		'sam_social_accounts_whatsapp', // field name
		'sanitize_text_field' // sanitization function
	);
    /* telegram */
    add_settings_field(
		'sam_social_accounts_telegram',
		'Telegram',
		'sam_social_accounts_telegram_field_html', // function which prints the field
		'sam-social-accounts-settings', // page slug
		'sam_social_accounts_section', // section ID
		array( 
			'label_for' => 'sam_social_accounts_telegram',
			'class' => 'banner-text',
		)
	);
    register_setting(
		'sam_social_accounts_settings', // settings group name
		'sam_social_accounts_telegram', // field name
		'sanitize_text_field' // sanitization function
	);

    /* Snapchat */
	add_settings_field(
		'sam_social_accounts_snapchat',
		'Spanchat',
		'sam_social_accounts_snapchat_field_html', // function which prints the field
		'sam-social-accounts-settings', // page slug
		'sam_social_accounts_section', // section ID
		array( 
			'label_for' => 'sam_social_accounts_snapchat',
			'class' => 'banner-text',
		)
	);
    register_setting(
		'sam_social_accounts_settings', // settings group name
		'sam_social_accounts_snapchat', // field name
		'sanitize_text_field' // sanitization function
	);

}

add_action('admin_init', 'sam_social_accounts_register_settings');


/*******************
 * Read fields
 *******************/

function sam_social_accounts_facebook_field_html() {
	$value = get_option( 'sam_social_accounts_facebook' );
	echo '<label>https://facebook.com/</label><input type="text" id="sam_social_accounts_facebook" name="sam_social_accounts_facebook" value="'.$value.'" />';
}

function sam_social_accounts_instagram_field_html() {
	$value = get_option( 'sam_social_accounts_instagram' );
	echo '<label>https://instagram.com/</label><input type="text" id="sam_social_accounts_instagram" name="sam_social_accounts_instagram" value="'.$value.'" />';
}

function sam_social_accounts_whatsapp_field_html() {
	$value = get_option( 'sam_social_accounts_whatsapp' );
	echo '<input type="text" id="sam_social_accounts_whatsapp" name="sam_social_accounts_whatsapp" value="'.$value.'" />';
}

function sam_social_accounts_youtube_field_html() {
	$value = get_option( 'sam_social_accounts_youtube' );
	echo '<label>https://youtube.com/</label><input type="text" id="sam_social_accounts_youtube" name="sam_social_accounts_youtube" value="'.$value.'" />';
}

function sam_social_accounts_telegram_field_html() {
	$value = get_option( 'sam_social_accounts_telegram' );
	echo '<input type="text" id="sam_social_accounts_telegram" name="sam_social_accounts_telegram" value="'.$value.'" />';
}

function sam_social_accounts_snapchat_field_html() {
	$value = get_option( 'sam_social_accounts_snapchat' );
	echo '<input type="text" id="sam_social_accounts_snapchat" name="sam_social_accounts_snapchat" value="'.$value.'" />';
}