<?php

$clinics = get_terms([
    'taxonomy' => 'zain_clinics',
    'hide_empty' => false,
    'order_by' => 'name',
    'order' => 'ASC'
]);

?>

<?php if ($clinics) : ?>
    <section id="home-clinics" class="w-100 px-0 my-5" data-aos="fadeIn" data-aos-delay="200">
        <div class="container px-xl-5">
            <div class="row">
                <div class="py-4">
                    <h2 class="section-title mx-auto fst-italic fw-light"><?= pll_e('clinics'); ?></h2>
                </div>
            </div>
            <div class="row">
                <div class="col-12 col-lg-4">
                    <div class="card border-0 shadow h-100">
                        <div class="card-body p-0">
                            <div class="accordion" id="clinics-accordion">
                                <?php
                                $i = 0;
                                $j = 0;
                                foreach ($clinics as $clinic) :

                                    // Get posts for each treatment_category
                                    $pll_clinic = pll_get_term($clinic->term_id);

                                    $args = [
                                        'number' => 10,
                                        'orderby' => 'sort_order',
                                        'order' => 'ASC',
                                        'post_type' => 'clinic_treatments',
                                        'post_status' => 'publish',
                                        'suppress_filters' => true,
                                        'tax_query' => array(
                                            array(
                                                'taxonomy' => 'zain_clinics',
                                                'field' => 'term_id',
                                                'terms' => $pll_clinic
                                            )
                                        ),
                                    ];

                                    $treatments = get_posts($args);

                                    if ($treatments) : ?>
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="acctab-<?= $clinic->term_id; ?>">
                                                <button class="accordion-button <?= ($i > 0) ? 'collapsed' : ''; ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-<?= $clinic->term_id; ?>" aria-expanded="<?= ($i == 0) ? 'true' : 'false'; ?>" aria-controls="collapse-<?= $clinic->term_id; ?>">
                                                    <span class="icon">
                                                        <img src="<?= get_field('image_icon', $clinic->taxonomy . '_' . $clinic->term_id); ?>">
                                                    </span>
                                                    <?= $clinic->name; ?>
                                                </button>
                                            </h2>
                                            <div id="collapse-<?= $clinic->term_id; ?>" class="accordion-collapse collapse <?= ($i == 0) ? 'show' : ''; ?>" aria-labelledby="acctab-<?= $clinic->term_id; ?>" data-bs-parent="#clinics-accordion">
                                                <div class="accordion-body">
                                                    <?php
                                                    if ($treatments) : ?>
                                                        <div class="nav flex-column nav-pills me-3" id="clinic-vertical-tab" role="tablist" aria-orientation="vertical">
                                                            <?php
                                                            foreach ($treatments as $treatment) : ?>
                                                                <button class="nav-link text-start pb-3 <?= ($j == 0) ? 'active' : ''; ?>" id="v-<?= $treatment->ID; ?>-tab" data-bs-toggle="pill" data-bs-target="#v-<?= $treatment->ID; ?>" type="button" role="tab" aria-controls="v-<?= $treatment->ID; ?>" aria-selected="<?= ($j == 0) ? 'true' : 'false'; ?>">
                                                                    <?= $treatment->post_title; ?>
                                                                </button>
                                                            <?php $j++;
                                                            endforeach; ?>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                <?php $i++;
                                    endif;
                                endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-lg-8">
                    <div class="tab-content" id="clinic-vertical-tab-content ps-5">
                        <?php
                        $i = 0;
                        foreach ($clinics as $clinic) :
                            // Get posts for each treatment_category
                            $pll_clinic = pll_get_term($clinic->term_id);

                            $args = [
                                'number' => 10,
                                'orderby' => 'sort_order',
                                'order' => 'ASC',
                                'post_type' => 'clinic_treatments',
                                'post_status' => 'publish',
                                'suppress_filters' => true,
                                'tax_query' => array(
                                    array(
                                        'taxonomy' => 'zain_clinics',
                                        'field' => 'term_id',
                                        'terms' => $pll_clinic
                                    )
                                ),
                            ];

                            $treatments = get_posts($args);

                            if ($treatments) : ?>
                                <?php
                                foreach ($treatments as $treatment) : ?>
                                    <div class="tab-pane fade <?= ($i == 0) ? 'show active' : ''; ?>" id="v-<?= $treatment->ID; ?>" role="tabpanel" aria-labelledby="v-<?= $treatment->ID; ?>-tab">
                                        <div class="w-100 text-center mb-4">
                                            <?= get_the_post_thumbnail($treatment->ID,'', ['class' => 'img-fluid ']); ?>
                                        </div>
                                        <h3 class="mb-3"><?= $treatment->post_title; ?></h3>
                                        <?= $treatment->post_content; ?>
                                        <div class="mt-5 w-100 text-end">
                                            <a href="<?= get_permalink($treatment->ID); ?>" class="btn btn-gold"><?= pll_e('read_more'); ?></a>
                                        </div>
                                    </div>
                                <?php $i++;
                                endforeach; ?>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>