<?php

$args = [
    'number' => 10,
    /* 'orderby' => 'sort_order',
    'order' => 'ASC', */
    'post_type' => 'brands',
    'post_status' => 'publish',
    'suppress_filters' => true,
];

$posts = get_posts($args);

if ($posts) : ?>
    <section id="brands" class="w-100 px-0 my-5" data-aos="fadeIn" data-aos-delay="200">
        <div class="container-fluid h-100">
            <div class="d-flex h-100">
                <div class="swiper">
                    <div class="swiper-wrapper d-flex h-100 align-items-stretch">
                        <?php foreach ($posts as $post) : setup_postdata($post); ?>
                            <div class="swiper-slide p-5 h-100 align-items-stretch">
                                <div class="card w-100 rounded-circle shadow py-4 h-100">
                                    <div class="card-body d-flex">
                                        <?php the_post_thumbnail('square-150', ['class' => 'card-img-top my-auto']); ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
            </div>
        </div>
        <script>
            jQuery(function($) {
                var swiper = new Swiper("#brands .swiper", {
                    slidesPerView: 1,
                    spaceBetween: 10,
                    loop: true,
                    navigation: {
                        nextEl: ".swiper-button-next",
                        prevEl: ".swiper-button-prev",
                    },
                    breakpoints: {
                        640: {
                            slidesPerView: 2,
                            spaceBetween: 10,
                        },
                        992: {
                            slidesPerView: 3,
                            spaceBetween: 10,
                        },
                        1200: {
                            slidesPerView: 4,
                            spaceBetween: 5,
                        },
                        1500: {
                            slidesPerView: 5,
                            spaceBetween: 10,
                        },
                        1900: {
                            slidesPerView: 6,
                            spaceBetween: 10,
                        },
                    },
                });
            });
        </script>
    </section>
<?php endif; ?>