<nav id="main-navbar" class="navbar navbar-expand-lg navbar-light bg-white shadow-0">
    <div class="container px-0">
        <a class="navbar-brand mt-2 mt-lg-0" href="<?php echo get_home_url(); ?>">
            <?php
            // Custom Logo
            $custom_logo_id = get_theme_mod('custom_logo');
            $logo = wp_get_attachment_image_src($custom_logo_id, 'full');

            $site_logo = '';

            if (has_custom_logo()) {
                $site_logo = '<img  class="img-fluid" id="logo" src="' . esc_url($logo[0]) . '" alt="' . esc_attr(get_bloginfo('name')) . '" title="' . esc_attr(get_bloginfo('name')) . '">';
            } else {
                $site_logo = '<h1>' . esc_attr(get_bloginfo('name')) . '</h1>';
            }

            echo $site_logo;
            ?>
        </a>
        <button class="navbar-toggler btn-gold rounded" type="button" data-bs-toggle="collapse" data-bs-target="#main-navbar-content" aria-controls="main-navbar-content" aria-expanded="false" aria-label="Toggle navigation">
            <i class="fas fa-bars"></i>
        </button>
        <div class="collapse navbar-collapse" id="main-navbar-content">
            <?php if (has_nav_menu('main-menu')) : ?>

                <?php
                $args = array(
                    'theme_location' => 'main-menu',
                    'container'      => false,
                    'menu_class'     => 'navbar-nav ms-auto my-auto',
                    'depth'          => 2,
                    'walker'         => new Bootstrap_NavWalker(), // This controls the display of the Bootstrap Navbar
                    'fallback_cb'    => '__return_false', // For menu fallback
                );
                wp_nav_menu($args); ?>

            <?php endif; ?>
        </div>
    </div>
</nav>