<?php

namespace App\Exports;

use App\Models\Appointment;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ExportAppointments implements FromCollection, WithHeadings
{

    /**
     * @return \Illuminate\Support\Collection
    */
    public function headings(): array
    {
        $th = [
            '#',
            __('admin/appointments.columns.ref_number'),
            __('admin/appointments.columns.appointment_date'),
            __('admin/appointments.columns.patient_name'),
            __('admin/appointments.columns.patient_mobile'),
            __('admin/appointments.columns.treatment'),
            __('admin/appointments.columns.start_time'),
            __('admin/appointments.columns.is_scheduled'),
        ];

        if ( is_admin() || count(allowed_branches()) > 1) {
            $th[] = __('admin/appointments.columns.branch');
        }

        return $th;
    }


    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
       
        $model = new Appointment();

        $select = $model->appointmentsListColumns();

        return Appointment::allowedBranches()->select($select)
                            ->join('treatments', 'appointments.treatment_id', '=', 'treatments.id')
                            ->join('branches', 'appointments.branch_id', '=', 'branches.id')
                            ->join('patients', 'appointments.patient_id', '=', 'patients.id')
                            ->orderBy('appointment_date','DESC')
                            ->where('appointments.postponed', '=', 0)
                            ->get();
    }
}
