<?php

use App\Libraries\UserNotifier;
use App\Models\Patient;
use App\Models\PatientNotification;
use App\Models\User;
use Illuminate\Support\Facades\Log;

if (!function_exists('notify_user')) {

    function notify_user(int $user_id, string $title, string $body, string $link = null, string $icon = null)
    {

        $notify = new UserNotifier();

        $notify->notify($user_id, $title, $body, $link, $icon);
    }
}
//-----------------------------------------------
if (!function_exists('user_notifications')) {

    function user_notifications()
    {

        $notify = new UserNotifier();

        return $notify->getNotifications();
    }
}
//-----------------------------------------------
if (!function_exists('user_notifications_count')) {

    function user_notifications_count()
    {

        $notify = new UserNotifier();

        return $notify->unreadNotificationsCount();
    }
}
//-----------------------------------------------
if (!function_exists('send_sms')) {

    function send_sms($mobile_no, $message, $check_limit = true, $is_patient = true)
    {

        if (!$is_patient) {
            // get user
            $user = User::where('mobile', $mobile_no)->first();
        } else {
            // get patient
            $user = Patient::where('mobile', $mobile_no)->first();
        }

        if ($check_limit) {

            if ($user) {

                $current_sms_count = $user->sms_count;

                $limit = config('sms.limit_per_day');

                if ($current_sms_count >= $limit) {
                    return __('sms.error.limit');
                }
            } else {
                return '404';
            }
        }

        $mobile = ltrim($mobile_no, '0');

        $sms_link = config('sms.sms_link') . '&to=970' . $mobile . '&message=' . $message . '&sender=Zain%20Clinic';

        $sms_link = str_replace(' ', '%20', $sms_link);
        $sms_link = str_replace('<br>', '%0A', $sms_link);

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $sms_link);

        curl_setopt($ch, CURLOPT_HEADER, 0);

        //curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);

        curl_close($ch);

        //$response = '1:00';
        
        // update sms count
        $response_status = explode(":", $response);

        if ( $user && $response_status && $response_status[0] == 1) {

            $db_sms_count = $user->sms_count;

            $sms_count = $db_sms_count + 1;

            $user->update(['sms_count' => $sms_count]);

            return true;
        }

        return false;
    }
}
//-----------------------------------------------

if (!function_exists('notify_patient')) {

    /**
     * Send push notification to patient mobile app
     *
     * @param string $title
     * @param string $body
     * @param array $patient_ids Array of patient_ids
     * @return boolean
     */
    function notify_patient(string $title, string $body, array $patient_ids)
    {

        foreach ($patient_ids as $id) {

            $patient = Patient::findOrFail($id);

            $tokens = [];

            if ($patient->device_token) {

                $tokens[] = $patient->device_token;
            }
        }

        if (!empty($tokens)) {

            $headers = [
                'Authorization: key=' . config('mobile_app.firebase_api_key'),
                'Content-Type: application/json',
            ];

            $message = [
                "registration_ids" => $tokens,

                "notification" => [
                    "title" => $title,
                    "body" => $body,
                    "sound" => "default" // required for sound on ios
                ],
            ];

            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');

            curl_setopt($ch, CURLOPT_POST, true);

            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($message));

            $response = curl_exec($ch);

            $decoded = json_decode($response, true);

            Log::info($decoded);

            if (array_key_exists('success', $decoded) && $decoded['success'] == 1) {

                foreach ($patient_ids as $id) {

                    $notification = [
                        'title' => $title,
                        'body' => $body,
                        'sent_to' => $id,
                        'sent_by' => user_id(),
                    ];

                    PatientNotification::create($notification);
                }
                return true;
            }
        }
    }
    return false;
}
