<?php

namespace App\Http\Controllers\Admin\Reports;

use App\Http\Controllers\Admin\Controller;
use App\Libraries\Tabler;
use App\Models\Appointment;
use App\Models\User;
use App\Models\UserActivityLog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class UserActivityController extends Controller
{
    public function index(Request $request)
    {

        $table = $this->table($request);

        $data = $table->initTable();

        // Override from Tabler
        $data['search_form_action'] = route('admin.reports.user_activity');

        $query_string = request()->query();
       
        $args = '';

        if ( $query_string ) {

            $args = '?';

            foreach ( $query_string as $key => $value ) {
                
                $args .= $key .'='. $value;

            }

        }

        $data['print_all'] = route('admin.reports.user_activity.print',['selection'=>'all']) . $args;
        $data['print_current'] = route('admin.reports.user_activity.print',['selection'=>'current']) . $args;;

        $this->loadView('reports.user_activity', 'reports.user_activity.title', 'reports.user_activity', [], $data);
    }

    public function print(Request $request, $selection)
    {

        if ($selection == 'all') {

            $obj = Appointment::allowedBranches()
                ->select(['treatments.treatment as treatment_title', DB::raw('count(*) as total')])
                ->join('treatments', 'appointments.treatment_id', '=', 'treatments.id')
                ->groupBy('treatment_title')
                ->orderBy('total', 'DESC')
                ->orderBy('treatment_title', 'ASC');

            $th = ['treatment_title', 'total'];

            // to remove th stdClass
            $data['rows'] = (array) json_decode(json_encode($obj->get()->toArray()), true);

            foreach ($th as $db_col) {

                $data['columns'][$db_col] = '<th>' . __('admin/reports.booked_appointments.columns.' . $db_col) . '</th>';
            }
        } else {

            $table = $this->table($request);

            $result = $table->initTable();

            $rows = $result['result']->toArray();

            $data['rows'] = $rows['data'];

            $data['columns'] = $result['columns'];
        }

        $data['_page_title'] = __('admin/reports.booked_appointments.title');

        echo view('admin.reports.printable.general_table', $data);
    }

    private function table(Request $request)
    {

        $model = new UserActivityLog();

        //$lang_key = str_replace($this->scope.'.', '', $this->route_key) . '.columns.' . $db_col;


        //$columns[$db_col] = '<th>' . __($this->scope.'/' . $lang_key) . '</th>';
      
        $user_model = new User();

        $full_name = $user_model->selectFullName();

        $get = __('admin/reports.user_activity.text.get');
        $post = __('admin/reports.user_activity.text.post');

        $request_method  = DB::raw("IF(request_method ='GET','" . $get . "', '" . $post . "') AS request_method ");
        
        $select = ['user_activity_logs.id','route', $request_method,$full_name,
        
        DB::raw('DATE_FORMAT(`user_activity_logs`.`created_at`, "%Y-%m-%d @ %h:%i:%s %p") as action_time')];

        $model = $model->allowedUsers();

        $model = $model->where('user_id','!=',1);

        $model = $model->join('users', 'user_activity_logs.user_id', '=', 'users.id');

        //$model = $model->groupBy('treatment_title');

        //$model = $model->orderBy('total', 'DESC');

        //$model = $model->orderBy('treatment_title', 'ASC');

        $th = ['user_full_name', 'route','request_method','action_time'];

        $sortable = ['user_full_name', 'route','request_method','action_time'];

        $searchable = ['user_full_name','route','request_method','action_time'];

        $table = new Tabler('admin.reports.user_activity', $model, $select, $th, $sortable, $searchable, $request, true);

        return $table;
    }
}
