<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Offer;
use Illuminate\Http\Request;

class Offers extends Controller
{
    public function list()
    {

        $result = Offer::select(['id', 'title', 'description', 'start_date', 'end_date', 'image'])->get()->toArray();

        $offers = [];

        if ($result) {

            foreach ($result as $row) {
                $offer = [
                    'id' => $row['id'],
                    'title' => $row['title'],
                    'description' => $row['description'],
                    'start_date' => $row['start_date'],
                    'end_date' => $row['end_date'],
                ];

                if ($row['image']) {
                    $offer['image'] = url(config('admin.public_uploads_dir') . '/' . $row['image']);
                } else {
                    $offer['image'] = '';
                }

                $offers[] = $offer;
            }
        }

        return response()->json(['offers' => $offers], 200);
    }

    public function info(Request $request, $offer_id)
    {

        $result = Offer::where('id', $offer_id)->get()->toArray();

        $offer = [];

        if ($result) {
            foreach ($result as $row) {

                $offer = [
                    'id' => $row['id'],
                    'title' => $row['title'],
                    'description' => $row['description'],
                    'start_date' => $row['start_date'],
                    'end_date' => $row['end_date'],
                ];

                if ($row['image']) {
                    $offer['image'] = url(config('admin.public_uploads_dir') . '/' . $row['image']);
                } else {
                    $offer['image'] = '';
                }
            }
        }

        return response()->json(['offer' => $offer]);
    }
}
