<?php

namespace App\Http\Controllers\Patient;

use App\Http\Controllers\Patient\Controller;
use App\Libraries\Tabler;
use App\Models\Complaint;
use App\Models\Patient;
use App\Rules\GeneralText;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Illuminate\Validation\Rule;

class ComplaintsController extends Controller
{
    public function index(Request $request){

        $model = new Complaint();
        //$model = $model->with('patients');

        $yes = __('admin/common.text.yes');
        $no = __('admin/common.text.no');
        
        $is_resolved = DB::raw("IF(is_resolved=0,'".$no."', '".$yes."') AS is_resolved");

        $select = ['complaints.id','complaint_date','description',$is_resolved,'complaints.created_at','complaints.updated_at'];

        
        //$model = $model->allowedPatients();
        $model = $model->where('complaints.patient_id',user_id());
       
        $th = ['complaint_date', 'description', 'is_resolved', 'created_at', 'updated_at'];

        $sortable = ['complaint_date','is_resolved'];
        
        $searchable = ['description','is_resolved'];

        $table = new Tabler('patient.complaints', $model, $select, $th, $sortable, $searchable, $request,true,'patient');

        $data = $table->initTable();

        $data['patient'] = Patient::findOrFail(patient_id());
        
        $this->loadView('complaints.list','complaints.title','complaints',[],$data);
        
    }

    public function downloadAttachment(Request $request, Complaint $complaint)
    {
        if ( !is_admin() && !in_array($complaint->patient_id,allowed_patients()) ){
            abort(404);
        }

        $path = config('admin.complaints_dir') . '/' . $complaint->patient_id . '/' . $complaint->attachment;

        if (Storage::exists($path)) {

            return Storage::download($path);
        }

        abort(404);
    }

    public function add(Request $request)
    {

        if ($request->getMethod() == 'POST') {

            $min_date = date('Y-m-d', strtotime("-1 week"));
            $max_date = date('Y-m-d');

            $rules = [
                'description' => ['required', 'max:5000', new GeneralText],
                'complaint-date' => ['required', 'before_or_equal:' . $max_date, 'after_or_equal:' . $min_date],
                'attachment' => ['mimes:png,jpg,jpeg,mp4,m4v', 'min:10', 'max:20480']
            ];

            if ( !is_admin() ){
                $rules['patient'] = ['required', 'exists:patients,id',Rule::in(allowed_patients())];
            }else{
                $rules['patient'] = ['required', 'exists:patients,id'];
            }

            $validated = $request->validate($rules);

            $complaint = [
                'patient_id' => $validated['patient'],
                'description' => $validated['description'],
                'complaint_date' => date('Y-m-d', strtotime($validated['complaint-date'])),
                'created_by' => user_id()
            ];

            if ($request->file('attachment') && $request->file('attachment')->isValid()) {

                $patient_dir = config('admin.complaints_dir') . '/' . $validated['patient'];

                $file_name = time() . '.' . $request->file('attachment')->guessExtension();

                $request->file('attachment')->storeAs($patient_dir, $file_name);

                $complaint['attachment'] = $file_name;
            }

            Complaint::create($complaint);

            return redirect()->route('admin.complaints')->with('success', __('admin/common.msgs.success.add'));
        }

        $data['patients'] = Patient::allowedPatients()->get();

        $this->loadView('complaints.add', 'complaints.add_title', 'complaints.add', [], $data, ['bs-datepicker/dp-bs-4.min.css'], ['momentjs/moment.min.js', 'bs-datepicker/dp-bs-4.min.js']);
    }
}
