<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

/**
 * Api Request Localization
 */
class ApiLocalization
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {

        if ( $request->has('lang') ) {

            if ( in_array( $request->input('lang') , ['en','ar'] ) && $request->input('lang') != App::getLocale() ){

                session()->put('locale', $request->lang);        

                App::setLocale($request->input('lang'));
            }
        }
        
        return $next($request);
    }
}
