<?php 

namespace App\Libraries;

use App\Models\Notification;

class UserNotifier{


    /**
     * Notify User
     *
     * @param integer $user_id
     * @param string $title
     * @param string $body
     * @param string|null $link
     * @param string|null $icon
     * @return void
     */
    public function notify(int $user_id, string $title, string $body,string $link = null,string $icon = null){


        if ( !is_admin() && !in_array($user_id,allowed_users()) ){
            abort(404);
        }

        $notification = [
            'title' => $title,
            'body' => $body ,
            'icon' => $icon ,
            'link' => $link,
            'sent_to' => $user_id,
            'sent_by' => user_id(), // logged in user id
        ];

        Notification::create($notification);

    }


    public function getNotifications(){
 
        $notifications = Notification::orderBy('sent_at','desc')->where(['sent_to' => user_id()])->limit(5)->get();

        return $notifications;
    }

    public function unreadNotificationsCount(){
 
        $count = Notification::where(['sent_to' => user_id(), 'read_at' => null])->count();

        return $count;
    }



}