<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Branch extends Model
{
    use HasFactory;

    protected $table = 'branches';

    protected $fillable = ['branch','phone','address','region_id'];

    protected $casts = [
        'work_start_time'  => 'date:H:i',
        'work_end_time'  => 'date:H:i',
    ];



    /**
     * Scope a query to filter by allowed branches only
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeAllowedBranches($query)
    {
        return (!is_admin() ) ? $query->whereIn('branches.id', allowed_branches()) : $query;
    }

    /**
     * Treatments
     *
     * @return Illuminate\Database\Eloquent\Concerns\HasRelationships::belongsToMany
     */
    public function treatments(){
        return $this->belongsToMany(Treatment::class)->withPivot(['devices','price']);
    }
    //--------------------------------------
    /**
     * Users
     *
     * @return Illuminate\Database\Eloquent\Concerns\HasRelationships::belongsToMany
     */
    public function users(){
        return $this->belongsToMany(User::class);
    }
    //--------------------------------------
    /**
     * Region
     *
     * @return @return Illuminate\Database\Eloquent\Concerns\HasRelationships::belongsTo
     */
    public function region()
    {
        return $this->belongsTo(Region::class);
    }

    public function appointments(){
        return $this->hasMany(Appointment::class);
    }


    public function getStartTimeAmAttribute(){
        return date('h:i A', strtotime($this->work_start_time ) );
    }
    
    public function getStartTimeAttribute(){
        return date('H:i', strtotime($this->work_start_time) );
    }

    public function getEndTimeAmAttribute(){
        return date('h:i A', strtotime($this->work_end_time ) );
    }

    public function getEndTimeAttribute(){
        return date('H:i', strtotime($this->work_end_time ) );
    }


}
