<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ComplaintComments extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id','comment','complaint_id','patient_id'
    ];

    //--------------------------------------------

    public function complaint(){

        return $this->belongsTo(Complaint::class);
        
    }
    //--------------------------------------------

    public function user(){

        return $this->belongsTo(User::class);
        
    }
    //--------------------------------------------

    public function patient(){

        return $this->belongsTo(Patient::class);
        
    }

    //--------------------------------------------

    public function getCommentTimeAttribute(){

        return date('D, Y-m-d @ h:i:s A', strtotime($this->created_at));

    }
}
