<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PatientAttachments extends Model
{
    use HasFactory;

    protected $fillable = ['patient_id', 'title', 'path'];


    
    /**
     * Scope a query to filter by allowed patients only
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeFiltered($query)
    {

        return (!is_admin() ) ? $query->whereIn('patient_id', allowed_patients()) : $query;
        
    }


    public function patient()
    {
        return $this->belongsTo(Patient::class);
    }
}
