<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="robots" content="noindex">
    <title>{{ config('app.name') }} | {{ $_page_title }}</title>
    <link rel="stylesheet" href="{{ asset('plugins/fontawesome/css/fontawesome.min.css') }}">
    @if (app()->getLocale() == 'ar')
        <link rel="stylesheet" href="{{ asset('fonts/tajawal/stylesheet.css') }}">
        <link rel="stylesheet" href="{{ asset('admin/css/bootstrap-rtl.css') }}">
        <link rel="stylesheet" href="{{ asset('admin/css/admin-rtl.css') }}">
    @else
        <link rel="stylesheet" href="{{ asset('fonts/roboto/roboto.css') }}">
        <link rel="stylesheet" href="{{ asset('admin/css/bootstrap.css') }}">
        <link rel="stylesheet" href="{{ asset('admin/css/admin.css') }}">
    @endif
    @if ($_css)
        @foreach ($_css as $item)
            <link rel="stylesheet" href="{{ asset('plugins/' . $item) }}">
        @endforeach
    @endif
    <script src="{{ asset('plugins/jquery/jquery-3.6.0.min.js') }}"></script>
</head>

<body class="hold-transition sidebar-mini-md sidebar-mini layout-fixed">
    <div class="wrapper">
        @include('admin.app.navbar')
        @include('admin.app.sidebar')
        <div class="content-wrapper">
            <section class="content">
                <div class="container-fluid px-lg-3 px-xl-4">
                    <div class="content-header row">
                        <div class="col-12 col-lg-6 px-1 my-auto">
                            <h1 class="m-0">{{ $_page_title }}</h1>
                        </div>
                        <div class="col-12 col-lg-6 px-1 my-auto text-right">
                            <!-- breadcrumbs -->
                            {!! $_breadcrumbs !!}
                            <!-- ./breadcrumbs -->
                        </div>
                        <div class="col-12">
                            <hr class="mb-0">
                        </div>
                    </div>
                    <div class="content-body">
                        <div id="loading-overlay">
                            <span class="fas fa-spinner fa-3x fa-spin"></span>
                        </div>
                        @if ($errors->any())
                            <div id="error-alerts" class="col-12">
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    @foreach ($errors->all() as $error)
                                        <span>{{ $error }}</span></br>
                                    @endforeach
                                    <button type="button" class="close" data-dismiss="alert"
                                        aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            </div>
                        @endif
                        @if (Session::has('danger'))
                            <div id="error-alerts" class="col-12">
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">

                                    <span>{!! Session::get('danger') !!}</span></br>

                                    <button type="button" class="close" data-dismiss="alert"
                                        aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            </div>
                        @endif
                        @if (Session::has('success'))
                            <div class="col-12">
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    <span>{!! Session::get('success') !!}</span>
                                    <button type="button" class="close" data-dismiss="alert"
                                        aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            </div>
                        @endif
                        @if (Session::has('info'))
                            <div class="col-12">
                                <div class="alert alert-info alert-dismissible fade show" role="alert">
                                    <span>{!! Session::get('info') !!}</span>
                                    <button type="button" class="close" data-dismiss="alert"
                                        aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            </div>
                        @endif
                        @include($_page)
                    </div>
                </div>
            </section>
        </div>
        <footer class="main-footer elevation-3">
            Developed By: <a href="https://auxiliumps.com" class="text-secondary">Au<b class="text-info">X</b>ilium Technology</a>
            
            <div class="float-right d-none d-sm-inline-block">
                This page took {{ microtime(true) - LARAVEL_START }} seconds to render
            </div>
        </footer>

        <div class="modal fade" id="action-confirm-modal" data-backdrop="static" data-keyboard="false" tabindex="-1"
            aria-labelledby="action-confirm-modal-label" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="action-confirm-modal-label">
                            {{ __('admin/common.confirm_modal.title') }}
                        </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                    </div>
                    <div class="modal-footer d-lex justify-content-between">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="{{ asset('admin/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('admin/js/bootstrap.js') }}"></script>
    @if ($_js)
        @foreach ($_js as $item)
            <script src="{{ asset('plugins/' . $item) }}"></script>
        @endforeach
    @endif
    <script src="{{ asset('admin/js/admin.js') }}"></script>

    <div class="modal fade" id="confirm-delete-modal" data-backdrop="static" data-keyboard="false" tabindex="-1"
        aria-labelledby="confirm-delete-modal-label" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="confirm-delete-modal-label">
                        {{ __('admin/common.confirm_modal.delete_title') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    {{ __('admin/common.confirm_modal.delete_msg') }}
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary mr-auto" data-dismiss="modal"
                        title="{{ __('admin/common.buttons.cancel') }}">{{ __('admin/common.buttons.cancel') }}</button>
                    <a href="#" class="btn btn-danger btn-confirm-delete">{{ __('admin/common.buttons.delete') }}</a>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {

            $(document).on('change','.custom-file-input', function() {
                let fileName = $(this).val().substring($(this).val().indexOf(":") + 1);
                fileName = fileName.replace("\\fakepath\\", "");
                $(this).next('.custom-file-label').html(fileName);
            })

            $('.btn-delete').on('click', function(e) {

                e.preventDefault();

                let href = $(this).attr('data-href');

                $('#confirm-delete-modal .btn-confirm-delete').attr('href', href);

                $('#confirm-delete-modal').modal('show');

            });
        });
    </script>
    {{-- <script src="https://www.gstatic.com/firebasejs/9.6.5/firebase-compat.js"></script>
    <script src="https://www.gstatic.com/firebasejs/9.6.5/firebase-app-compat.js"></script>
    <script src="https://www.gstatic.com/firebasejs/9.6.5/firebase-messaging-compat.js"></script>
    <script>

        // Your web app's Firebase configuration
        // For Firebase JS SDK v7.20.0 and later, measurementId is optional
        const firebaseConfig = {
            apiKey: "AIzaSyDGZep9UYMKb5hubx4ZXWc1C97Z0YREpBU",
            authDomain: "zain-clinic.firebaseapp.com",
            projectId: "zain-clinic",
            storageBucket: "zain-clinic.appspot.com",
            messagingSenderId: "479149046768",
            appId: "1:479149046768:web:f0cda4c8d5eca1f1393b35",
 /*            measurementId: "G-K6741GNZNR" */
        };

        // Initialize Firebase
        firebase.initializeApp(firebaseConfig);
        const messaging = firebase.messaging();
    </script> --}}
</body>

</html>
