<div class="col-12">
    <div class="card bg-white p-3">
        <form action="{{ route('admin.complaints.save') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="form-group row mb-3">
                <div class="col-12 col-lg-6">
                    <label class="col-form-label required" for="patient">{{ __('admin/complaints.form.patient') }}</label>
                    <select id="patient" name="patient" class="form-control">
                        <option value="-1" disabled selected></option>
                        @foreach ($patients as $patient)
                            <option value="{{ $patient->id }}" @if ( old('patient') == $patient->id ) {{ 'selected' }} @endif>{{ $patient->patient_name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-lg-6">
                    <label for="description" class="col-form-label required">
                        {{ __('admin/complaints.form.description') }}
                    </label>
                    <textarea class="form-control" rows="10"
                        name="description" id="description">{{ old('description') }}</textarea>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-lg-6">
                    <label for="complaint-date" class="col-form-label required">{{ __('admin/complaints.form.date') }}</label>
                    <div class="input-group date" id="complaint-date" data-target-input="nearest">
                        <input type="text" name="complaint-date" class="form-control datetimepicker-input"
                            data-target="#complaint-date" />
                        <div class="input-group-append" data-target="#complaint-date" data-toggle="datetimepicker">
                            <div class="input-group-text"><i class="fas fa-calendar"></i></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-lg-6">
                    <label for="complaint-attachment" class="col-form-label">
                        {{ __('admin/complaints.form.attachment') }}
                    </label>
                    <div class="input-group">
                        <div class="custom-file">
                            <input type="file" name="attachment" class="custom-file-input" id="complaint-attachment"
                                aria-describedby="complaint-attachment">
                            <label class="custom-file-label" for="complaint-attachment">{{ __('admin/complaints.form.browse') }}</label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <x-admin.form.save-button title="{{ __('admin/common.btn.save') }}" />
            </div>
        </form>
    </div>
    <script>
        $(document).ready(function() {

            var startdate = moment().subtract(1, "week").format("YYYY-MM-DD");

            $('#complaint-date').datepicker({
                format: 'yyyy-mm-dd',
                endDate: '0d',
                startDate: startdate,
                defaultViewDate: startdate,
            });
        });
    </script>
</div>
