<div class="col-12">
    <div class="card bg-white p-3">
        <form action="{{ route('admin.notifications.send') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="form-group row mb-3">
                <div class="col-12 col-lg-6">
                    <label for="add-title" class="col-form-label required">
                        {{ __('admin/notifications.form.title') }}
                    </label>
                    <input type="text" name="title" class="form-control" id="add-title" value="{{ old('title') }}">
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-lg-6">
                    <label for="add-users" class="col-form-label">
                        {{ __('admin/notifications.form.users') }}
                    </label>
                    <select id="" name="" class="form-control">
                        <option value="">All</option>
                        <option value="">Males</option>
                        <option value="">Females</option>
                        <option value="">Specific Region</option>
                        <option value="">Specific Patients</option>
                    </select>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-lg-6">
                    <label for="add-users" class="col-form-label">
                        {{ __('admin/notifications.form.patients') }}
                    </label>
                    <select id="patients" name="patients[]" class="form-control selectpicker" data-live-search="true" multiple>
                        @foreach ($patients as $patient)
                            <option value="{{$patient->id}}" data-subtext="{{ $patient->mobile }}">{{ $patient->full_name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-lg-6">
                    <label for="add-body" class="col-form-label">
                        {{ __('admin/notifications.form.body') }}
                    </label>
                    <textarea name="body" class="form-control" rows="5">{{ old('body') }}</textarea>
                </div>
            </div>
            <div class="form-group row">
                <x-admin.form.save-button title="{{ __('admin/common.btn.save') }}" />
            </div>
        </form>
    </div>

    <script>

        $(document).ready(function () {

        });
    </script>
</div>
