<div class="col-12">
    <form id="pretest-form" action="{{ route('admin.pretests.update', $patient_pretest) }}" method="POST"
        enctype="multipart/form-data" id="add-appointment-form" class="p-3 bg-white">
        @csrf
        <div class="form-group row">
            <div class="col-12 col-lg-6 col-xl-4">
                <label class="col-form-label required" for="patients">{{ __('admin/pretests.form.patient') }}</label>
                <select id="patients" name="patient" class="form-control selectpicker" data-live-search="true">
                    @foreach ($patients as $patient)
                        <option value="{{ $patient->id }}" @if ($patient->id == old('patient', $patient_pretest->patient_id)) selected  @endif>{{ $patient->full_name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-12 col-lg-6 col-xl-4">
                <label class="col-form-label required" for="pretests">{{ __('admin/pretests.form.form') }}</label>
                <select id="pretests" name="pretest" class="form-control selectpicker" data-live-search="true">
                    @foreach ($pretests as $pretest)
                        <option value="{{ $pretest->id }}" @if ($pretest->id == old('pretest', $patient_pretest->pretest_id)) selected  @endif>{{ $pretest->title }}</option>
                    @endforeach
                </select>
            </div>
            <div class="col-12 col-lg-6 col-xl-4 mt-auto text-right">
                <button type="button" id="view-form"
                    class="btn btn-primary btn-sm">{{ __('admin/pretests.view_form') }}</button>
            </div>
        </div>
        <div id="pretest-form-content">
            @if ($form)
                {!! $form !!}
            @endif
        </div>
    </form>
    <div class="modal" id="load-confirm-modal" data-backdrop="static" data-keyboard="false" tabindex="-1"
        aria-labelledby="load-confirm-modal-label" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="load-confirm-modal-label">
                        {{ __('admin/common.confirm_modal.title') }}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    {{ __('admin/common.confirm_modal.reload') }}
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary btn-close"
                        data-dismiss="modal">{{ __('admin/common.buttons.close') }}</button>
                    <button type="button"
                        class="btn btn-primary btn-confirm">{{ __('admin/common.buttons.reload') }}</button>
                </div>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function() {

            $(document).on('click', '#view-form', function() {

                if ($('#pretest-form-content').children().length > 0) {

                    $('#load-confirm-modal').modal('show');

                } else {
                    loadForm()

                }
            });

            $('#load-confirm-modal .btn-confirm').on('click', function(e) {
                loadForm()
            });

            function loadForm() {
                let patient = $('#patients').val();
                let pretest_form = $('#pretests').val();

                $.ajax({
                    type: "GET",
                    url: "{{ route('admin.pretests.get_form') }}" + '/' + patient + '/' +
                        pretest_form,
                    dataType: "html",
                    beforeSend: function() {
                        $('#error-alerts').remove();
                        $('#pretest-form-content').html('');
                        $('#loading-overlay').addClass('is-active');
                    },
                    error: function(XMLHttpRequest) {
                        console.log(XMLHttpRequest.responseText);
                        $('#loading-overlay').removeClass('is-active');
                    },
                    success: function(data) {
                        $('#load-confirm-modal').modal('hide');
                        $('#pretest-form-content').html(data);
                    },
                    complete: function(msg) {
                        $('#loading-overlay').removeClass('is-active');
                    }
                });
            }

            $('#pretest-form').on('submit', function(e) {

                e.preventDefault();

                $('#pretest-modal .btn-save').attr("disabled", true);

                let form = $(this);

                let formData = new FormData(form[0]);

                if ($('.datetimepicker-input').val()) {

                    formData.append('form-date', $('.datetimepicker-input').val())
                }


                let url = form.attr('action')

                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    type: "POST",
                    url: url,
                    data: formData,
                    dataType: 'json',
                    contentType: false,
                    processData: false,
                    cache: false,
                    error: function(xhr) {
                        let parsed = JSON.parse(xhr.responseText);
                        console.log(parsed);

                        $('#error-alerts').remove();

                        let html = '<div id="error-alerts" class="col-12">';
                        html +=
                            '<div class="alert alert-danger alert-dismissible fade show" role="alert">';
                        //$.each(parsed.error, function(key, err) {
                        html += '<span>' + parsed.error + '</span></br>';
                        //});
                        html +=
                            '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>';
                        html += '</div>';
                        html += '</div>';

                        $('.content-body').prepend(html);

                        $('#pretest-form .btn-save').attr("disabled", false);

                        $('html,body').animate({
                            scrollTop: 0
                        }, 'slow');
                    },
                    success: function(data) {
                        if (data.success) {
                            if (data.success) {
                                window.location.href =
                                    "{{ route('admin.pretests') }}";
                            }
                        }
                    }
                });
                return false;
            });

            $('body').on('focus', ".input-group.date", function() {
                var start_date = moment().subtract(5, "years").format("YYYY-MM-DD");
                $(this).datepicker({
                    format: 'yyyy-mm-dd',
                    endDate: '0d',
                    startdate: start_date,
                });
            });
        });
    </script>
</div>
