<div class="table-toolbar col mb-3">
    <div class="row">
        <x-admin.table.search :action="$search_form_action" :keywords="$search" />
        <x-admin.table.rows-per-page :selected="$rows" />
        <x-admin.form.reset-button link="{{ route('admin.pretests') }}" />
        <x-admin.form.print-button route-name="admin.pretests"/>
        <x-admin.form.add-button title="{{ __('admin/pretests.add') }}" link="{{ route('admin.pretests.add') }}" />
    </div>
</div>
<x-admin.table.table :rows="$result" :columns="$columns" base-link="{{ $route_key }}"
    :action-buttons="['info_modal','edit','delete']" />

<div class="modal fade" id="pretest-modal" data-backdrop="static" data-keyboard="false" tabindex="-1"
    aria-labelledby="pretest-modal-label" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title font-weight-bold" id="pretest-modal-label"></h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body px-5 container-fluid">
                <div id="modal-error-alerts" class="col-12">
                </div>
                <div class="modal-body-content">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">
                    {{ __('admin/common.buttons.close') }}
                </button>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {

        $('.btn-info-modal').on('click', function(e) {

            e.preventDefault();

            let row_id = $(this).attr('data-row-id');

            $.ajax({
                type: "GET",
                url: "{{ route($route_key) }}/info/" + row_id,
                dataType: "html",
                beforeSend: function() {
                    $('#loading-overlay').addClass('is-active');
                },
                error: function(XMLHttpRequest) {
                    alert('error');
                    $('#loading-overlay').removeClass('is-active');
                },
                success: function(data) {
                    $('#pretest-modal .modal-body').html(data);
                    $('#loading-overlay').removeClass('is-active');
                    $('#pretest-modal').modal('show');
                },
            });

        });

    });
</script>
