<div class="col-12">
    <div class="card bg-white p-3">
        <form action="{{ route('admin.treatments.save') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="row">
                <div class="col">
                    <h4>{{ __('admin/treatments.text.treatment') }}</h4>
                    <hr>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-lg-8 col-xxl-4">
                    <label for="add-treatment"
                        class="col-form-label required">{{ __('admin/treatments.form.treatment') }}</label>
                    <input type="text" name="treatment" class="form-control" id="add-treatment"
                        value="{{ old('treatment') }}">
                </div>
                <div class="col-12 col-lg-8 col-xxl-4">
                    <label for="add-category"
                        class="col-form-label required">{{ __('admin/treatments.form.category') }}</label>
                        <select name="category" class="form-control selectpicker" id="add-category" data-live-search="trues">
                            @foreach ($categories as $category)
                                <option value="{{ $category->id }}">{{ $category->name }}</option>
                            @endforeach
                        </select>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-lg-8 col-xxl-4">
                    <label for="add-pretest"
                        class="col-form-label required">{{ __('admin/treatments.form.pretests') }}</label>
                    <select name="pretests[]" class="form-control selectpicker" id="add-pretest" multiple>
                        @foreach ($pretests as $pretest)
                            <option value="{{ $pretest->id }}">{{ $pretest->title }}</option>
                        @endforeach
                    </select>
                </div>
                {{-- <div class="col-12 col-lg-8 col-xxl-4">
                    <label for="add-treatments-confilcts"
                        class="col-form-label">{{ __('admin/treatments.form.conflicts') }}</label>
                    <select name="conflict-treatments[]" class="form-control selectpicker" id="add-treatments-confilcts" multiple data-live-search="true">
                        <option value=""></option>
                        @foreach ($treatments as $treatment)
                            <option value="{{ $treatment->id }}">{{ $treatment->treatment }}</option>
                        @endforeach
                    </select>
                </div> --}}
            </div>
            <div class="form-group row mb-3">
              
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-lg-8 col-xl-4">
                    <label for="add-treatments-period"
                        class="col-form-label required">{{ __('admin/treatments.form.session_period') }}</label>
                    <input type="number" name="session-period" class="form-control" id="add-session-period"
                        value="{{ old('session-period', config('admin.min_session_duration') ) }}" min="{{ config('admin.min_session_duration') }}" max="300" step="{{ config('admin.min_session_duration') }}">
                </div>
                <div class="col-12 col-lg-8 col-xl-4">
                    <label for="add-session-rooms"
                        class="col-form-label required">{{ __('admin/treatments.form.min_sessions') }}</label>
                    <input type="number" name="min-sessions" class="form-control" id="add-min-sessions"
                        value="{{ old('min-sessions', 1) }}" min="1" max="50">
                </div>
            </div>
            <div class="row mt-5">
                <div class="col">
                    <h4>{{ __('admin/treatments.text.details') }}</h4>
                    <hr class="w-100">
                </div>
            </div>
            <div id="treatment-details">
                @php
                $i = 0
                @endphp
                @foreach ($branches as $branch)
                <div class="form-group row mb-3">
                    <div class="col-12 col-lg-auto mb-3 d-flex">
                        <div class="custom-control custom-switch my-auto">
                            <br>
                            <input type="checkbox" name="branches[{{$branch->id}}]" class="custom-control-input" value="{{$branch->id}}" id="treatment-details-{{$i}}"  @if ($branch->id == old('branches.'.$branch->id)) checked @endif>
                            <label class="custom-control-label" for="treatment-details-{{$i}}">{{ $branch->branch }}</label>
                        </div>
                    </div>
                    <div class="col-12 col-lg mb-3 offset-1">
                        <label class="col-form-label">{{ __('admin/treatments.form.session_rooms') }}</label>
                        <input type="number" name="treatment-devices[{{$branch->id}}]" class="form-control" value="{{ old('treatment-devices.'.$branch->id, 1) }}" min="1" max="50" @if ($branch->id != old('branches.'.$branch->id)) disabled @endif>
                    </div>
                    <div class="col-12 col-lg mb-3">
                        <label class="col-form-label">{{ __('admin/treatments.form.price') }}</label>
                        <input type="number" name="treatment-prices[{{$branch->id}}]" class="form-control my-auto" value="{{ old('treatment-prices.'.$branch->id, 0) }}" min="0" max="100000" step="50" @if ($branch->id != old('branches.'.$branch->id)) disabled @endif>
                    </div>
                </div>
                @php
                $i++
                @endphp
                @endforeach
            </div>
            <div class="form-group row mt-5">
                <x-admin.form.save-button />
            </div>
        </form>
    </div>
    <script>
        $(document).ready(function() {
            $('#treatment-details .custom-switch').on('change', function (e) {
                let checked = e.target.checked;
                let inputs = $(this).parent().parent().find('.form-control');
                
                if ( checked ){
                    inputs.each(function( index, element ) {
                        $( element ).removeAttr( "disabled");
                    });
                }else{
                    inputs.each(function( index, element ) {
                        $( element ).attr("disabled","");
                    });
                }
                
            });

        });
    </script>
</div>
