<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="robots" content="noindex">
    <title>{{ config('app.name') }} | {{ $_page_title }}</title>
    <link rel="stylesheet" href="{{ asset('plugins/fontawesome/css/fontawesome.min.css') }}">
    @if (app()->getLocale() == 'ar')
        <link rel="stylesheet" href="{{ asset('fonts/noto/stylesheet.css') }}">
        <link rel="stylesheet" href="{{ asset('website/css/bootstrap.rtl.min.css') }}">
        <link rel="stylesheet" href="{{ asset('website/css/style-rtl.css') }}">
    @else
        <link rel="stylesheet" href="{{ asset('fonts/roboto/roboto.css') }}">
        <link rel="stylesheet" href="{{ asset('website/css/bootstrap.min.css') }}">
        <link rel="stylesheet" href="{{ asset('website/css/style.css') }}">
    @endif
    <link href="{{ asset('website/css/aos.css') }}" rel="stylesheet" />

    @if ($_css)
        @foreach ($_css as $item)
            <link rel="stylesheet" href="{{ asset('plugins/' . $item) }}">
        @endforeach
    @endif
    <script src="{{ asset('plugins/jquery/jquery-3.6.0.min.js') }}"></script>
</head>

<body class="bg-dark text-light">
    @if (!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || $_SERVER['HTTP_X_REQUESTED_WITH'] != config('mobile_app.app_id'))
        @include('patient.app.navbar')
    @endif
    <div class="container">
        <div id="page-alerts" class="row">
            @if ($errors->any())
                <div id="error-alerts" class="col-12">
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                        @foreach ($errors->all() as $error)
                            <span>{{ $error }}</span></br>
                        @endforeach
                        <button type="button" class="btn-close" data-bs-dismiss="alert"
                            aria-label="Close"></button>
                    </div>
                </div>
            @endif
            @if (Session::has('error'))
                <div id="error-alerts" class="col-12">
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                        <span>{{ Session::get('error') }}</span>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"
                            aria-label="Close"></button>
                    </div>
                </div>
                @php session()->pull('error'); @endphp
            @endif
            @if (Session::has('success'))
                <div class="col-12">
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <span>{{ Session::get('success') }}</span>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"
                            aria-label="Close"></button>
                    </div>
                </div>
                @php session()->pull('success'); @endphp
            @endif
            @if (Session::has('info'))
                <div class="col-12">
                    <div class="alert alert-info alert-dismissible fade show" role="alert">
                        <span>{{ Session::get('info') }}</span>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"
                            aria-label="Close"></button>
                    </div>
                </div>
                @php session()->pull('info'); @endphp
            @endif
        </div>
    </div>

    @include($_page)


    <footer class="bg-darker mt-4">
        <section id="contact-us" class="pt-5 bg-darker">
            <div class="container">
                <div class="row align-items-stretch">
                    <div class="col-12 col-lg-6 mx-auto">
                        {{-- <h2 class="fs-2 text-capitalize text-gold-light text-center">{{ __('website/contact.follow_us.title') }}</h2> --}}
                        <div class="row social justify-content-between mt-5">
                            @if($_footer['social_accounts'])
                                @foreach ($_footer['social_accounts'] as $account)
                                    <div class="col-6 col-md-4 col-lg-auto text-center mb-3">
                                        <a href="{{ $account->link }}" class="text-center" title="{{ $account->title }}"> 
                                            <i class="{{ $account->icon }} fa-2x"></i><br>
                                            <span class="text-white fw-light">{{ $account->username }}</span>
                                        </a>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </section>
        
        {{-- <div class="container">
            <div class="row pt-4">
                <div class="col-12 col-lg-3 col-xl-2 mb-5 text-center">
                    <img src="{{ asset(config('website.footer_logo')) }}" title="{{ config('app.name') }}" class="img-fluid">
                </div>
                @if($_footer['branches'] )
                    <div class="col offset-lg-1 my-3">
                        <span class="h3 fw-normal text-gold">فروعنا</span>
                        <hr>
                        <div class="row">
                            @foreach ($_footer['branches'] as $branch )
                                <div class="d-flex col-12 col-md-6 col-lg-4 col-xl mt-3">
                                    <i class="fas fa-map-marker-alt fa-2x me-2 text-gold"></i>
                                    <div class="branch d-flex flex-column">
                                        <p class="text-white-50 fs-5">{{ $branch->branch }}</p>
                                        <p class="text-white-50 fs-6">{{ $branch->address }}</p>
                                        <p class="text-white-50 fs-6">{{ $branch->mobile }}</p>
                                    </div>
                                    
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif
            </div>
        </div> --}}
        <div class="container-fluid text-center bg-dark-75 py-3">
            <span>جميع الحقوق محفوظة لمركز زين للتجميل &copy;</span>
        </div>
    </footer>
    <script src="{{ asset('website/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('website/js/aos.js') }}"></script>
    <script>
        let navbar = $('#main-navbar');
        let nav_brand = $('#main-navbar .navbar-brand img');

        //let $offset = $(window).height() - $('#main-navbar').height();
        let $offset = $(window).height();

        window.addEventListener('scroll', function() {

            if (window, pageYOffset < $offset) {
                navbar.addClass('bg-dark-50');
                navbar.removeClass('bg-darker');
            } else {
                navbar.removeClass('bg-dark-50');
                navbar.addClass('bg-darker');
            }
        });
    </script>
    @if ($_js)
        @foreach ($_js as $item)
            <script src="{{ asset('plugins/' . $item) }}"></script>
        @endforeach
    @endif
    <script>
        jQuery(function($) {
            AOS.init({
                once: true,
                duration: 1000
            });
        });
    </script>

    @hasSection('scripts')
        @yield('scripts')
    @endif
</body>

</html>
