<div class="container-fluid">
    <div id="loading-overlay">
        <span class="fas fa-spinner fa-3x fa-spin"></span>
    </div>
    <div class="row mt-5 px-5">
        @include('patient.sidebar', ['active' => route('patient.appointments') ])
        <div class="col bg-dark-75">
            <form action="{{ route('patient.appointments.update', $appointment->app_id) }}" method="POST"
                enctype="multipart/form-data" id="add-appointment-form" class="p-3">
                @csrf
                <div class="form-group row">
                    <div class="col-12 col-lg-6 col-xl-4">
                        <label class="col-form-label" for="branches">{{ __('admin/appointments.form.branch') }}</label>
                        <select id="branches" name="branch" class="form-select">
                            @foreach ($branches as $branch)
                                <option value="{{ $branch->id }}"
                                    <?= $appointment->branch_id == $branch->id ? 'selected' : '' ?>>
                                    {{ $branch->branch }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-12 col-lg-6 col-xl-4">
                        <label class="col-form-label"
                            for="treatments">{{ __('patient/appointments.form.treatment') }}</label>
                        <select id="treatments" name="treatment" class="form-select">
                            @foreach ($treatments as $treatment)
                                <option value="{{ $treatment->id }}"
                                    <?= $appointment->treatment_id == $treatment->id ? 'selected' : '' ?>>
                                    {{ $treatment->treatment }}</option>
                            @endforeach
                        </select>
                    </div>
                    <input type="hidden" value="{{ $appointment->app_id }}" name="app-id">
                </div>
                <div id="sessions-table" class="form-group row mt-5">
                    {!! $app_table !!}
                </div>
            </form>
            <script>
                $(document).ready(function() {

                    $(document).on('change', '#branches', function() {

                        let branch = this.value;

                        $.ajax({
                            type: "GET",
                            url: "{{ route('patient.appointments.get_treatments') }}" + '/' + branch,
                            dataType: "json",
                            beforeSend: function() {
                                $('#loading-overlay').addClass('is-active');
                            },
                            error: function(XMLHttpRequest) {
                                console.log(XMLHttpRequest.responseText);
                                $('#loading-overlay').removeClass('is-active');
                                $('#treatments').attr('disabled');

                            },
                            success: function(data) {
                                let html = '<option value="-1" disabled selected>-- Select --</option>';

                                $.each(data.treatments, function(index, value) {

                                    html += '<option value="' + value.id + '">' + value
                                        .treatment + '</option>'
                                });

                                $('#treatments').html(html);

                                $('#treatments').removeAttr('disabled');
                                $('#treatments').selectpicker('refresh');;
                            },
                            complete: function(msg) {
                                $('#loading-overlay').removeClass('is-active');
                            }
                        });


                    });

                    $(document).on('change', '#treatments', function() {

                        let treatment = this.value;
                        let branch = $("#branches option:selected").attr('value');

                        $.ajax({
                            type: "GET",
                            url: "{{ route('patient.appointments.get_calendar') }}" + '/' +
                                '{{ patient_id() }}' + '/' + branch + '/' +
                                treatment + '/0',
                            dataType: "html",
                            cache: false,
                            beforeSend: function() {
                                $('#loading-overlay').addClass('is-active');
                            },
                            error: function(XMLHttpRequest) {
                                alert('error');
                                console.log(XMLHttpRequest);
                                $('#loading-overlay').removeClass('is-active');
                            },
                            success: function(data) {
                                $('#sessions-table').html(data);
                            },
                            complete: function(msg) {
                                $('#loading-overlay').removeClass('is-active');
                            }
                        });
                    });

                });
            </script>
        </div>
    </div>
</div>
