@include('pretests.patient_info')

<div id="form-date-group" class="form-group col-12 mb-4">
    <label for="form-date" class="col-form-label required">{{ __('pretests.form_date') }}</label>
    <div class="input-group date" id="form-date" data-target-input="nearest">
        <input type="text" name="form-date" class="form-control datetimepicker-input" data-target="#form-date" value="{{ date('Y-m-d')}}">
        <div class="input-group-append" data-target="#form-date" data-toggle="datetimepicker">
            <div class="input-group-text"><i class="fas fa-calendar"></i></div>
        </div>
    </div>
</div>
<div class="form-group col-12 mb-4">
    <label for="q1" class="form-label font-weight-bold">{{ __('pretests.general_questions.q1') }}</label><br>
    <div class="custom-control custom-radio custom-control-inline ml-4">
        <input type="radio" name="q1" id="q1_1" value="1" class="custom-control-input">
        <label class="custom-control-label" for="q1_1">{{ __('patient/common.yes') }}</label>
    </div>
    <div class="custom-control custom-radio custom-control-inline ml-4">
        <input type="radio" name="q1" id="q1_2" value="0" class="custom-control-input">
        <label class="custom-control-label" for="q1_2">{{ __('patient/common.no') }}</label>
    </div>
    <div id="q1-input" class="row">
        <div class="col-12 col-lg-6">
            <input type="text" name="q1-input" class="form-control d-none disabled" disabled>
        </div>
    </div>
</div>
<div class="form-group col-12 mb-4">
    <label for="q2" class="form-label font-weight-bold">{{ __('pretests.general_questions.q2') }}</label><br>
    <div class="custom-control custom-radio custom-control-inline ml-4">
        <input type="radio" name="q2" data-q="q2" id="q2_1" value="1" class="custom-control-input">
        <label class="custom-control-label" for="q2_1">{{ __('patient/common.yes') }}</label>
    </div>
    <div class="custom-control custom-radio custom-control-inline ml-4">
        <input type="radio" name="q2" data-q="q2" id="q2_2" value="0" class="custom-control-input">
        <label class="custom-control-label" for="q2_2">{{ __('patient/common.no') }}</label>
    </div>
    <div id="q2-input" class="row">
        <div class="col-12 col-lg-6">
            <input type="text" name="q2-input" class="form-control d-none disabled" disabled>
        </div>
    </div>
</div>
<div id="q3-group" class="form-group col-12 mb-4">
    <label for="q3" class="form-label font-weight-bold">{{ __('pretests.general_questions.q3') }}</label><br>
    <div class="custom-control custom-radio custom-control-inline ml-4">
        <input type="radio" name="q3" data-q="q3" id="q3_1" value="1" class="custom-control-input">
        <label class="custom-control-label" for="q3_1">{{ __('patient/common.yes') }}</label>
    </div>
    <div class="custom-control custom-radio custom-control-inline ml-4">
        <input type="radio" name="q3" data-q="q3" id="q3_2" value="0" class="custom-control-input">
        <label class="custom-control-label" for="q3_2">{{ __('patient/common.no') }}</label>
    </div>
    <div id="q3-input" class="row">
        <div class="col-12 col-lg-6">
            <input type="text" name="q3-input" class="form-control d-none disabled" disabled>
        </div>
    </div>
</div>
<div id="q4-group" class="form-group col-12 mb-4">
    <label for="q4" class="form-label font-weight-bold">{{ __('pretests.general_questions.q4') }}</label><br>
    <div class="custom-control custom-radio custom-control-inline ml-4">
        <input type="radio" name="q4" data-q="q4" id="q4_1" value="1" class="custom-control-input">
        <label class="custom-control-label" for="q4_1">{{ __('patient/common.yes') }}</label>
    </div>
    <div class="custom-control custom-radio custom-control-inline ml-4">
        <input type="radio" name="q4" data-q="q4" id="q4_2" value="0" class="custom-control-input">
        <label class="custom-control-label" for="q4_2">{{ __('patient/common.no') }}</label>
    </div>
    <div id="q4-input" class="row">
        <div class="col-12 col-lg-6">
            <input type="text" name="q4-input" class="form-control d-none disabled" disabled>
        </div>
    </div>
</div>
{{-- Hide if patient is male and set the value manually to no when making the ajax call --}}
@if ($patient->gender == 'f')
    <div class="form-group col-12 mb-4">
        <label for="q5" class="form-label font-weight-bold">{{ __('pretests.general_questions.q5') }}</label><br>
        <div class="custom-control custom-radio custom-control-inline ml-4">
            <input type="radio" name="q5" data-q="q5" id="q5_1" value="1" class="custom-control-input">
            <label class="custom-control-label" for="q5_1">{{ __('patient/common.yes') }}</label>
        </div>
        <div class="custom-control custom-radio custom-control-inline ml-4">
            <input type="radio" name="q5" data-q="q5" id="q5_2" value="0" class="custom-control-input">
            <label class="custom-control-label" for="q5_2">{{ __('patient/common.no') }}</label>
        </div>
        <div id="q5-input" class="row">
            <div class="col-12 col-lg-6">
                <input type="text" name="q5-input" class="form-control d-none disabled" disabled>
            </div>
        </div>
    </div>
@endif
<div class="form-group mb-4 col-12">
    <label for="pretest-attachment" class="form-label font-weight-bold">
        {{ __('admin/complaints.form.attachment') }}
        <small class="text-muted">(5 MB maximum)</small>
    </label>
    <div class="input-group">
        <div class="custom-file">
            <input type="file" name="attachment" class="custom-file-input" id="pretest-attachment"aria-describedby="pretest-attachment">
            <label class="custom-file-label " for="pretest-attachment">
                {{ __('admin/complaints.form.browse') }}
            </label>
        </div>
    </div>
</div>
<div class="form-group col-12 mb-4">
    <label for="q6" class="form-label font-weight-bold">{{ __('pretests.general_questions.q6') }}</label><br>
    <textarea name="q6" class="form-control" id="q6" rows="5"></textarea>
</div>
<div class="form-group col-12 mb-4">
    <div class="custom-control custom-checkbox">
        <input type="checkbox" class="custom-control-input" value="1" name="credibility" id="credibility">
        <label class="custom-control-label" for="credibility">
            {{ __('pretests.general_questions.q7') }}</label>
    </div>
</div>
<div class="d-flex w-100">
    <x-admin.form.save-button title="{{ __('admin/common.buttons.save') }}" />

</div>

<script>
    $(document).ready(function() {
        $('#q2_1').change(function() {
            showInput(this)
        });
        $('#q2_2').change(function() {
            hideInput(this)
        });
        $('#q3_1').change(function() {
            showInput(this)
        });
        $('#q3_2').change(function() {
            hideInput(this)
        });
        $('#q4_1').change(function() {
            showInput(this)
        });
        $('#q4_2').change(function() {
            hideInput(this)
        });
        $('#q5_1').change(function() {
            showInput(this)
        });
        $('#q5_2').change(function() {
            hideInput(this)
        });
    });

    function showInput(radio) {

        let q = $(radio).attr('data-q');

        $(radio).parent().parent().find('#' + q + '-input input').removeClass('d-none disabled').removeAttr('disabled');

    }

    function hideInput(radio) {

        let q = $(radio).attr('data-q');

        $(radio).parent().parent().find('#' + q + '-input input').addClass('d-none disabled').attr('disabled','disabled');

    }
</script>
