@include('pretests.patient_info')
<div class="row">
    <div class="col-12 col-lg-6 col-xl-4">
        <label for="session-date" class="form-label">{{ __('pretests.laser_sessions.date') }}</label>
        <label>{{ $answers['session-date'] }}</label>
    </div>
    <div class="col-12 col-lg-6 col-xl-4">
        <label for="session-type" class="form-label">
            {{ __('pretests.laser_sessions.session_type') }}
        </label>
        <label>@if ( $answers['session-type'] == 'c' )  {{ __('pretests.laser_sessions.types.control') }} @else {{ __('pretests.laser_sessions.types.session') }} @endif</label>
    </div>
    <div class="col-12 col-lg-6 col-xl-4">
        <label for="session-type" class="form-label">
            {{ __('pretests.laser_sessions.session_number') }}
        </label>
        <label>{{ $answers['session-number'] }}</label>
    </div>
</div>
<div class="row mt-5">
    <div class="col-12">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>المنطقة</th>
                    <th>Spot Size</th>
                    <th>Pulse</th>
                    <th>E</th>
                    <th>طبيعة الشعر و لونه</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>
                        <label>الجسم</label>
                    </td>
                    <td>
                        <label>{{ $answers['body-spot-size'] }}</label>
                    </td>
                    <td>
                        <label>{{ $answers['body-pulse'] }}</label>
                    </td>
                    <td>
                        <label>{{ $answers['body-e'] }}</label>
                    </td>
                    <td>
                        <label>{{ $answers['body-hair'] }}</label>
                    </td>
                </tr>
                <tr>
                    <td>
                        <label>الوجه</label>
                    </td>
                    <td>
                        <label>{{ $answers['face-spot-size'] }}</label>
                    </td>
                    <td>
                        <label>{{ $answers['face-pulse'] }}</label>
                    </td>
                    <td>
                        <label>{{ $answers['face-e'] }}</label>
                    </td>
                    <td>
                        <label>{{ $answers['face-hair'] }}</label>
                    </td>
                </tr>
                <tr>
                    <td>
                        <label>المنطقة الحساسة</label>
                    </td>
                    <td>
                        <label>{{ $answers['sens-spot-size'] }}</label>
                    </td>
                    <td>
                        <label>{{ $answers['sens-pulse'] }}</label>
                    </td>
                    <td>
                        <label>{{ $answers['sens-e'] }}</label>
                    </td>
                    <td>
                        <label>{{ $answers['sens-hair'] }}</label>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    @if( array_key_exists('notes',$answers))
        <div class="form-group mb-4 col-12">
            <label for="notes" class="form-label font-weight-bold">{{ __('pretests.notes') }}</label><br>
            <label id="notes" class="form-label">{{ $answers['notes'] }}</label><br>
        </div>
    @endif
    @if( array_key_exists('attachment',$answers))
        <div class="form-group col-12 mb-4">
            <span class="font-weight-bold my-auto ml-auto mr-3">
                {{ __('admin/complaints.form.attachment') }}
            </span>
            <a href="{{ route('admin.pretests.download',[$patient->id, $answers['attachment'] ]) }}" class="btn btn-sm btn-info"
                target="_blank">
                <i class="fas fa-file-download"></i>
            </a>
        </div>
    @endif

</div>
