@include('pretests.patient_info')
<div class="row mt-4">
    <div id="form-date-group" class="form-group col-12 mb-4">
        <label for="form-date" class="col-form-label required">{{ __('pretests.form_date') }}</label>
        <div class="input-group date" id="form-date" data-target-input="nearest">
            <input type="text" name="form-date" class="form-control datetimepicker-input" data-target="#form-date" value="{{ $patient_pretest->form_date}}">
            <div class="input-group-append" data-target="#form-date" data-toggle="datetimepicker">
                <div class="input-group-text"><i class="fas fa-calendar"></i></div>
            </div>
        </div>
    </div>
    <div id="q1-group" class="form-group col-12 mb-4">
        <label for="q1" class="form-label font-weight-bold">{{ __('pretests.skin_care_questions.q1') }}</label><br>
        @php $q1_answers = __('pretests.skin_care_answers.q1') @endphp
        @foreach ((array) $q1_answers as $key => $answer)
            <div class="custom-control custom-radio ml-4">
                <input type="radio" name="q1" id="q1_{{ $key }}" value="{{ $key }}"
                    @if ($answers['q1'] == $key) checked @endif class="custom-control-input">
                <label class="custom-control-label" for="q1_{{ $key }}">{{ $answer }}</label>
            </div>
        @endforeach
    </div>
    @if ($patient->gender == 'f')
        <div id="q2-group" class="form-group col-12 mb-4">
            <label for="q2" class="form-label font-weight-bold">{{ __('pretests.skin_care_questions.q2') }}</label><br>
            <input type="text" name="q2" class="form-control" value="{{ $answers['q2'] }}">
        </div>
        <div id="q3-group" class="form-group col-12 mb-4">
            <label for="q3"
                class="form-label font-weight-bold">{{ __('pretests.skin_care_questions.q3') }}</label><br>
            <div class="custom-control custom-radio custom-control-inline ml-4">
                <input type="radio" name="q3" id="q3_1" value="1" class="custom-control-input" @if ($answers['q3'] == 1) checked @endif>
                <label class="custom-control-label" for="q3_1">{{ __('patient/common.yes') }}</label>
            </div>
            <div class="custom-control custom-radio custom-control-inline ml-4">
                <input type="radio" name="q3" id="q3_2" value="0" class="custom-control-input" @if ($answers['q3'] == 0) checked @endif>
                <label class="custom-control-label" for="q3_2">{{ __('patient/common.no') }}</label>
            </div>
            <div id="q3-input" class="row">
                <div class="col-12 col-lg-6">
                    @if(array_key_exists('q3-input', $answers ) )
                        <input type="text" name="q3-input" class="form-control" value="{{$answers['q3-input'] }}">
                    @else
                        <input type="text" name="q3-input" class="form-control d-none disabled" disabled="disabled">
                    @endif
                </div>
            </div>
        </div>
    @endif
    <div id="q4-group" class="form-group col-12 mb-4">
        <label for="q4" class="form-label font-weight-bold">{{ __('pretests.skin_care_questions.q4') }}</label><br>
        <div class="custom-control custom-radio custom-control-inline ml-4">
            <input type="radio" name="q4" id="q4_1" value="1" class="custom-control-input" @if ($answers['q4'] == 1) checked @endif>
            <label class="custom-control-label" for="q4_1">{{ __('patient/common.yes') }}</label>
        </div>
        <div class="custom-control custom-radio custom-control-inline ml-4">
            <input type="radio" name="q4" id="q4_2" value="0" class="custom-control-input" @if ($answers['q4'] == 0) checked @endif>
            <label class="custom-control-label" for="q4_2">{{ __('patient/common.no') }}</label>
        </div>
        <div id="q4-input" class="row">
            <div class="col-12 col-lg-6">
                @if(array_key_exists('q4-input', $answers ) )
                    <input type="text" name="q4-input" class="form-control" value="{{$answers['q4-input'] }}">
                @else
                    <input type="text" name="q4-input" class="form-control d-none disabled" disabled="disabled">
                @endif
            </div>
        </div>
    </div>
    <div id="q5-group" class="form-group col-12 mb-4">
        <label for="q5" class="form-label font-weight-bold">{{ __('pretests.skin_care_questions.q5') }}</label><br>
        <input type="text" name="q5" class="form-control" value={{ $answers['q5'] }}>
    </div>
    <div id="q6-group" class="form-group col-12 mb-4">
        <label for="q6" class="form-label font-weight-bold">{{ __('pretests.skin_care_questions.q6') }}</label><br>
        <div class="custom-control custom-radio custom-control-inline ml-4">
            <input type="radio" name="q6" id="q6_1" value="1" class="custom-control-input" @if ($answers['q6'] == 1) checked @endif>
            <label class="custom-control-label" for="q6_1">{{ __('patient/common.yes') }}</label>
        </div>
        <div class="custom-control custom-radio custom-control-inline ml-4">
            <input type="radio" name="q6" id="q6_2" value="0" class="custom-control-input" @if ($answers['q6'] == 0) checked @endif>
            <label class="custom-control-label" for="q6_2">{{ __('patient/common.no') }}</label>
        </div>
        <div id="q6-input" class="row">
            <div class="col-12 col-lg-6">
                @if(array_key_exists('q6-input', $answers ) )
                    <input type="text" name="q6-input" class="form-control" value="{{$answers['q6-input'] }}">
                @else
                    <input type="text" name="q6-input" class="form-control d-none disabled" disabled="disabled">
                @endif
            </div>
        </div>
    </div>
    <div id="q7-group" class="form-group col-12 mb-4">
        <label for="q7" class="form-label font-weight-bold">{{ __('pretests.skin_care_questions.q7') }}</label><br>
        <input type="text" name="q7" class="form-control" value={{ $answers['q7'] }}>
    </div>
    <div id="q8-group" class="form-group col-12 mb-4">
        <label for="q8" class="form-label font-weight-bold">{{ __('pretests.skin_care_questions.q8') }}</label><br>
        <input type="text" name="q8" class="form-control" value={{ $answers['q8'] }}>
    </div>
    <div id="q9-group" class="form-group col-12 mb-4">
        <label for="q9" class="form-label font-weight-bold">{{ __('pretests.skin_care_questions.q9') }}</label><br>
        @php $q9_answers = __('pretests.skin_care_answers.q9') @endphp
        @foreach ((array) $q9_answers as $key => $answer)
            <div class="custom-control custom-radio ml-4">
                <input type="radio" name="q9" id="q9_{{ $key }}" value="{{ $key }}"
                    class="custom-control-input" @if ($answers['q9'] == $key) checked @endif>
                <label class="custom-control-label" for="q9_{{ $key }}">{{ $answer }}</label>
            </div>
        @endforeach
        
        <input type="text" name="q9-input" class="form-control" @if(array_key_exists('q9-input', $answers ) ) value="{{ $answers['q9-input']}}" @endif>
    </div>
    @if (user_id())
        <div id="q10-group" class="form-group col-12 mb-4">
            <label for="q10"
                class="form-label font-weight-bold">{{ __('pretests.skin_care_questions.q10') }}</label><br>
            <textarea class="form-control" name="q10" rows="5">{{ $answers['q10'] }}</textarea>
        </div>
    @endif
    @if( array_key_exists('notes',$answers))
        <div class="form-group mb-4 col-12">
            <label for="notes" class="form-label font-weight-bold">{{ __('pretests.notes') }}</label><br>
            <textarea name="notes" class="form-control" id="notes" rows="5">{{ $answers['notes'] }}</textarea>
        </div>
    @endif
    @if( array_key_exists('attachment',$answers))
    <div class="form-group col-12 mb-4">
        <span class="font-weight-bold my-auto ml-auto mr-3">
            {{ __('admin/complaints.form.attachment') }}
        </span>
        <a href="{{ route('admin.pretests.download',[ $patient->id, $answers['attachment'] ] ) }}" class="btn btn-sm btn-info"
            target="_blank">
            <i class="fas fa-file-download"></i>
        </a>
    </div>
    @endif
    <div class="form-group mb-4 col-12">
        <label for="pretest-attachment" class="form-label font-weight-bold">
            {{ __('admin/complaints.form.attachment') }}
            <small class="text-muted">(5 MB maximum)</small>
        </label>
        <div class="input-group">
            <div class="custom-file">
                <input type="file" name="attachment" class="custom-file-input" id="pretest-attachment"aria-describedby="pretest-attachment">
                <label class="custom-file-label " for="pretest-attachment">
                    {{ __('admin/complaints.form.browse') }}
                </label>
            </div>
        </div>
    </div>
    <x-admin.form.save-button title="{{ __('admin/common.buttons.save') }}" />
    <script>
        $(document).ready(function() {
            $('#q3_1').change(function() {
                showInput(this)
            });
            $('#q3_2').change(function() {
                hideInput(this)
            });
            $('#q4_1').change(function() {
                showInput(this)
            });
            $('#q4_2').change(function() {
                hideInput(this)
            });
            $('#q6_1').change(function() {
                showInput(this)
            });
            $('#q6_2').change(function() {
                hideInput(this)
            });
        });

        function showInput(radio) {

            let q = $(radio).attr('name');

            $(radio).parent().parent().find('#' + q + '-input input').removeClass('d-none disabled').removeAttr('disabled');

        }

        function hideInput(radio) {

            let q = $(radio).attr('name');

            $(radio).parent().parent().find('#' + q + '-input input').addClass('d-none disabled').attr('disabled',
                'disabled');

        }
    </script>
</div>
