<?php

use App\Models\Appointment;
use App\Models\Branch;
use App\Models\Patient;
use App\Models\Role;
use App\Models\User;


if (!function_exists('has_permission')) {
    
    /**
     * If user has permission over a route name
     *
     * @param string $route_name
     * @return boolean
     */
    function has_permission($route_name)
    {
        $session_token = session()->token();

        $hashed = md5(md5($session_token));

        $user_id = session('user_id_'.$hashed);

        // if user exists

        $user = User::find($user_id);

        if ( $user->count() ){

            // user exists
            // check if user is admin
            if ( $user && $user->is_admin ) {

                // grant all permissions
                return true;
            
            }else{

                // User exists but not admin
                // Get role and permissions
                $role = $user->role;

                $permissions = Role::where('id',$role->id)->whereHas('permissions',function($q) use ($route_name) {
                    
                    $q->where('route_name', '=', $route_name);
        
                })->get();
        
                return ( $permissions->count() ) ? true : false;
            }
        }

        return false;

    }
}

if (!function_exists('user_id')) {
    
    /**
     * Return logged-in user id
     *
     * @return integer
     */
    function user_id()
    {
        $session_token = session()->token();

        $hashed = md5(md5($session_token));

        $user_id = session('user_id_'.$hashed);

        if ( $user_id ){
            return ( User::findOrFail($user_id) ) ? $user_id : 0;
        }

        return 0;

        

    }
}

if (!function_exists('user_name')) {
    
    /**
     * Return logged-in user name
     *
     * @return integer
     */
    function user_name()
    {

        $session_token = session()->token();

        $hashed = md5(md5($session_token));

        return session('user_name_'.$hashed);

    }
}

if (!function_exists('is_admin')) {
    
    /**
     * If the logged-in user is admin
     *
     * @return boolean
     */
    function is_admin()
    {

        $session_token = session()->token();

        $hashed = md5(md5($session_token));

        $user_id = session('user_id_'.$hashed);

        $user = User::find($user_id);

        return  ( $user && $user->is_admin )  ? true : false;

    }
}

if (!function_exists('user_role')) {
    /**
     * Get logged-in user's role id
     *
     * @return Illuminate\Database\Eloquent\Concerns\HasRelationships::belongsTo|integer
     */
    function user_role()
    {

        $session_token = session()->token();

        $hashed = md5(md5($session_token));

        $user_id = session('user_id_'.$hashed);

        $user = User::find($user_id);

        return  ( $user )  ? $user->role : 0;

    }
}

if ( !function_exists('rand_password')){

    function rand_password($length = 10,$complixity = 5){

        $chars = '';
        switch ($complixity) {
            case 1:
                $chars = 'abcdefghijklmnopqrstuvwxyz';
                break;
            case 2:
                $chars = 'abcdefghijkmnopqrstuvwxyz0123456789';
                break;
            case 3:
                $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHJKLMNOPQRSTUVWXYZ';
                break;
            case 4:
                $chars = 'abc0defgh1ijkmn2opqrs3tuv8wx4yz5ABC6DEF7GHJ8KLMNO9PQR2STU3VWX5YZ';
                break;
            case 5:
                $chars = 'abcd^efghi123jkm$nop$qrst!uvwx^yzAB$!C456DE!FGHJ%KLMNOPQ^RSTUVW%XYZ6%789&';
                break;
            
            default:
            $chars = 'abcd^efghi123jkm$nop$qrst!uvwx^yzAB$!C456DE!FGHJ%KLMNOPQ^RSTUVW%XYZ6%789&';
                break;
        }

        $random = str_shuffle($chars);
        return substr($random, 0, $length);
    }
}

if ( !function_exists('is_patient') ){

    function is_patient(){

        //$session_token = session()->token();

        //$hashed = md5(md5($session_token));

        //$user_id = session('user_id_'.$hashed);

        $patient_id = session('patient_info.patient_id');

        $patient = Patient::find($patient_id);

        return  ( $patient )  ? true : false;
    
    }
}
if ( !function_exists('patient_id') ){

    function patient_id(){
        
        $patient_id = session('patient_info.patient_id');

        return ( Patient::find($patient_id) ) ? $patient_id : 0;
    
    }
}

if ( !function_exists('allowed_branches')){
    
    function allowed_branches(){

        $user = User::find(user_id());


        $allowed_branches = [];


        if ( $user ){

            if ( $user->is_admin ){

                $allowed_branches = Branch::pluck('id')->toArray();

            }else{
                $allowed_branches =  $user->branches->pluck('id')->toArray();
            }

        }

        return $allowed_branches;


    }
}


if ( !function_exists('allowed_regions')){
    
    function allowed_regions(){

        $user = User::find(user_id());

        $allowed_regions = [];

        if ( $user ){

            if ( $user->is_admin ){

                $allowed_regions =  Branch::get()->pluck('region_id')->toArray();
            
            }else{

                $allowed_regions = $user->branches->pluck('region_id')->toArray();
            }
        }

        return $allowed_regions;
    }
}

if ( !function_exists('allowed_patients')){
    
    function allowed_patients(){
        
        $result_ids = [];

        // Get all patient ids
        $all_patients = Patient::select('id')->get();


        foreach ( $all_patients as $patient ){

            // check if patient_has an appointment
            if ( $patient->appointments->count() == 0 ){
                
                // If count == 0, then then is patient is public for all branches
                $result_ids[] = $patient->id;
            
            }

        }

        $patients_in_branches = Appointment::whereIn('branch_id',allowed_branches())->get();

        foreach ($patients_in_branches as $patient){
            if ( !in_array($patient->patient_id,$result_ids)){
                $result_ids[] = $patient->patient_id;
            }
        }

        return $result_ids;
        
    }
}
if ( !function_exists('allowed_users')){
    
    function allowed_users(){

        $branches = allowed_branches();

        $result = [];
        $users = [];

        foreach ( $branches as $branch_id){
            
            $branch = Branch::findOrFail($branch_id);

            $users = $branch->users;

            foreach ( $users as $user ){
                $result[] = $user->id;
            }
        }
        
        return $result;
    }
}

if ( !function_exists('allowed_treatments')){
    
    function allowed_treatments(){

        // get patient ids from appointments filtered by branch

        $allowed_branches = allowed_branches();


        $treatment_ids = [];

        foreach ($allowed_branches as $branch_id){

            $branch = Branch::find($branch_id);

            $treatments = $branch->treatments;

            foreach ( $treatments as $treatment){

                if ( !in_array($treatment->id,$treatment_ids)){
                    $treatment_ids[] = $treatment->id;
                }

            }

        }

        return $treatment_ids;

    }
}

if ( !function_exists('allowed_appointments')){
    
    function allowed_appointments(){

        $appointments = Appointment::whereIn('branch_id', allowed_branches())->pluck('id')->toArray();

        return $appointments;
    }
}




