<?php

namespace App\Http\Controllers\Admin;

use App\Exports\ExportPatient;
use App\Http\Controllers\Admin\Controller;
use App\Libraries\PatientCommon;
use App\Libraries\Tabler;
use App\Models\Patient;
use App\Models\Region;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Maatwebsite\Excel\Facades\Excel;

class PatientsController extends Controller
{
    /**
     * List Patients
     *
     * @param Request $request
     * @return void
     */
    public function index(Request $request)
    {
    
        // Route Key
        $route_key = 'admin.patients';

        // Prep the model
        $model = new Patient();

        $model = $model->join('regions', 'regions.id', '=', 'patients.region_id');

        $model = $model->allowedPatients();

        // Concatenating name columns
        $full_name = DB::raw("CONCAT(COALESCE(patients.first_name,''),' ',COALESCE(patients.second_name,''),' ',COALESCE(patients.third_name,''),' ',COALESCE(patients.last_name,'')) AS patient_name");
        //$full_name = DB::raw("CONCAT(patients.first_name,' ',patients.second_name,' ',patients.third_name,' ',patients.last_name) AS patient_name");

        // Changing m and f to Male & Female
        $male = __('admin/common.gender.male');
        $female = __('admin/common.gender.female');

        $gender = DB::raw("IF(gender='m','" . $male . "', '" . $female . "') AS gender");

        // Setting the parameters
        $select = ['patients.id', $full_name, 'mobile', $gender, 'regions.region as region'];
      
        $th = ['patient_name', 'mobile', 'gender', 'region'];
    

        $sortable = ['patient_name', 'mobile', 'gender', 'region'];
        

        //$searchable = ['first_name','second_name','third_name', 'patients.last_name','mobile','region'];
        $searchable = ['patient_name', 'mobile', 'region'];
 

        $table = new Tabler($route_key, $model, $select, $th, $sortable, $searchable, $request, true);

        $data = $table->initTable();

        $this->loadView('patients.index', 'patients.title', 'patients', [], $data);
    }
    /**
     * Add new patient
     *
     * @param Request $request
     * @return void
     */
    public function add(Request $request)
    {
        $min_dob = date('Y-m-d', strtotime("-70 years"));
        $max_dob = date('Y-m-d');

        if ($request->getMethod() == 'POST') {

            $patient_account = new PatientCommon();

            $result = $patient_account->register($request);

            if ($result) {

                return redirect()->route('admin.patients')->with('success', __('admin/common.msgs.success.add'));
            }
        }

        $data['regions'] = Region::orderBy('region')->get();

        $data['gen_password'] = Str::random(10);

        $data['min_dob'] = $min_dob;
        $data['max_dob'] = $max_dob;

        $this->loadView('patients.add', 'patients.add_title', 'patients.add', [], $data, ['bs-datepicker/dp-bs-4.min.css'], ['momentjs/moment.min.js', 'bs-datepicker/dp-bs-4.min.js']);
    }
    //-------------------------------------------------------------
    /**
     * Edit existing patient
     *
     * @param Request $request
     * @param Patient $patient
     * @return void
     */
    public function edit(Request $request, Patient $patient)
    {
        if ( !is_admin() && !in_array($patient->id,allowed_patients()) ){
            abort(404);
        }

        if ($request->getMethod() == 'POST') {

            $patient_common = new PatientCommon();

            $result = $patient_common->updateProfile($request, $patient);

            if ($result) {
                return redirect()->route('admin.patients')->with('success', __('admin/common.msgs.success.add'));
            }

            return false;
        }

        $data['patient'] = $patient;

        $data['regions'] = Region::orderBy('region')->get();

        $data['gen_password'] = Str::random(10);

        $this->loadView('patients.edit', 'patients.edit_title', 'patients.edit', $patient, $data,  ['bs-datepicker/dp-bs-4.min.css'], ['momentjs/moment.min.js', 'bs-datepicker/dp-bs-4.min.js']);
    }
    //------------------------------------------------------
    public function delete(Request $request, Patient $patient)
    {
        // if patient has appointments
        $appointments = $patient->appointments;

        if ( $appointments && $appointments->count() > 0){
        
            return redirect()->route('admin.patients')->with('danger', __('admin/common.msgs.error.delete'));
        
        }

        $patient->delete();

        return redirect()->route('admin.patients')->with('success', __('admin/common.msgs.success.delete'));
    }
    //------------------------------------------------------
    public function deleteTokens(Request $request, Patient $patient){

        $patient->tokens()->delete();

    }
    //------------------------------------------------------
    public function export(Request $request){

        return Excel::download(new ExportPatient(), 'patients.xlsx');
    }
    //------------------------------------------------------
    public function print(Request $request, $selection)
    {

        if ($selection == 'all') {

           

           
        } else {

        }

        /* $data['_page_title'] = __('admin/reports.patient_history.title');

        echo view('admin.printables.list', $data); */
    }

}
