<?php

namespace App\Http\Controllers\Admin\Reports;

use App\Http\Controllers\Admin\Controller;
use App\Libraries\Tabler;
use App\Models\Appointment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BookedAppointmentsController extends Controller
{
    public function index(Request $request)
    {

        $table = $this->table($request);

        $data = $table->initTable();

        // Override from Tabler
        $data['search_form_action'] = route('admin.reports.booked_appointments');

        $query_string = request()->query();
       
        $args = '';

        if ( $query_string ) {

            $args = '?';

            foreach ( $query_string as $key => $value ) {
                
                $args .= $key .'='. $value;

            }

        }

        $data['print_all'] = route('admin.reports.booked_appointments.print',['selection'=>'all']) . $args;
        $data['print_current'] = route('admin.reports.booked_appointments.print',['selection'=>'current']) . $args;;

        $this->loadView('reports.booked_appointments', 'reports.booked_appointments.title', 'reports.booked_appointments', [], $data);
    }

    public function print(Request $request, $selection)
    {

        if ($selection == 'all') {

            $obj = Appointment::allowedBranches()
                ->select(['treatments.treatment as treatment_title', DB::raw('count(*) as total')])
                ->join('treatments', 'appointments.treatment_id', '=', 'treatments.id')
                ->groupBy('treatment_title')
                ->orderBy('total', 'DESC')
                ->orderBy('treatment_title', 'ASC');

            $th = ['treatment_title', 'total'];

            // to remove th stdClass
            $data['rows'] = (array) json_decode(json_encode($obj->get()->toArray()), true);

            foreach ($th as $db_col) {

                $data['columns'][$db_col] = '<th>' . __('admin/reports.booked_appointments.columns.' . $db_col) . '</th>';
            }
        } else {

            $table = $this->table($request);

            $result = $table->initTable();

            $rows = $result['result']->toArray();

            $data['rows'] = $rows['data'];

            $data['columns'] = $result['columns'];
        }

        $data['_page_title'] = __('admin/reports.booked_appointments.title');

        echo view('admin.reports.printable.general_table', $data);
    }

    private function table(Request $request)
    {

        $model = new Appointment();

        $select = ['appointments.id', 'treatments.id as trtmnt_id', 'treatments.treatment as treatment_title', DB::raw('count(*) as total')];

        $model = $model->allowedBranches();

        $model = $model->join('treatments', 'appointments.treatment_id', '=', 'treatments.id');

        $model = $model->groupBy('treatment_title');

        //$model = $model->orderBy('total', 'DESC');

        //$model = $model->orderBy('treatment_title', 'ASC');

        $th = ['treatment_title', 'total'];

        $sortable = ['treatment_title', 'total'];

        $searchable = ['treatment_title'];

        $table = new Tabler('admin.reports.booked_appointments', $model, $select, $th, $sortable, $searchable, $request, true);

        return $table;
    }
}
