<?php

namespace App\Http\Controllers\Admin;

use App\Libraries\Tabler;
use App\Models\Review;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ReviewsController extends Controller
{
    public function index(Request $request){

        $model = new Review();

        $select = [ DB::raw('DATE_FORMAT(`created_at`, "%Y-%m-%d") as date_created'),'rating','review'];
        
        $model = $model->allowedAppointments();

        //$model = $model->join('appointments', 'reviews.appointment_id', '=', 'appointments.id');

        $th = ['date_created','rating','review'];

        $sortable = ['date_created','rating'];
        
        $searchable = ['date_created','rating','review'];

        $table = new Tabler('admin.reviews', $model, $select, $th, $sortable, $searchable, $request,true);

        $data = $table->initTable();

        $this->loadView('reviews.index', 'reviews.title', 'reviews', [], $data);


    }

    public function info(Request $request, Review $review){


    }
}
