<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Admin\Controller;
use App\Libraries\Tabler;
use App\Models\SocialAccount;
use App\Rules\EnAlphaSpaceDash;
use App\Rules\Username;
use Illuminate\Http\Request;

class SocialAccountsController extends Controller
{
    public function index(Request $request){

        $model = new SocialAccount();

        $model = $model->orderBy('title');

        $route_key = 'admin.social_accounts';

        $select = ['id','title','username'];

        $th_col = ['title','username'];
        $sortable = ['title','username'];
        $searchable = ['title','username'];

        $table = new Tabler($route_key,$model,$select,$th_col,$sortable,$searchable,$request);

        $data = $table->initTable();

        $this->loadView('social_accounts.index','social_accounts.title','social_accounts',[],$data);
    }

    public function add(Request $request){

        if ( $request->method() == 'POST' ){
            
            $validated = $request->validate([
                'title' => ['required','alpha_dash','min:2','max:50'],
                'icon' => ['required',new EnAlphaSpaceDash,'min:2','max:50'],
                'link' => ['nullable','url','min:2','max:50'],
                'username' => ['required',new Username,'min:2','max:50'],
            ]);

            SocialAccount::create($validated);

            return redirect()->route('admin.social_accounts')->with('success', __('admin/common.msgs.success.add'));
        }

        $this->loadView('social_accounts.add','social_accounts.add_title','social_accounts.add');
    }

    public function edit(Request $request, SocialAccount $social_account){

        if ( $request->method() == 'POST' ){
            
            $validated = $request->validate([
                'title' => ['required','alpha_dash','min:2','max:50'],
                'icon' => ['required',new EnAlphaSpaceDash,'min:2','max:50'],
                'link' => ['nullable','url','min:2','max:50'],
                'username' => ['required',new Username,'min:2','max:50'],
            ]);

            $social_account->update($validated);

            return redirect()->route('admin.social_accounts')->with('success', __('admin/common.msgs.success.edit'));
        }

        $data['social_account'] = $social_account; 

        $this->loadView('social_accounts.edit','social_accounts.edit_title','social_accounts.edit',$social_account,$data);

    }

    public function delete(Request $request,  SocialAccount $social_account){

        $social_account->delete();

        return redirect()->route('admin.social_accounts')->with('success', __('admin/common.msgs.success.delete') );
    }
}
