<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Rules\ArEnAlphaSpace;
use App\Rules\GeneralText;
use App\Rules\Mobile;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Validator;

class ContactUs extends Controller
{
    public function send(Request $request){


        $rules = [
            'name' => ['required', new ArEnAlphaSpace],
            'phone' => ['required', new Mobile],
            'email' => ['nullable', 'email'],
            'message' => ['required', new GeneralText],
        ];

        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {

            return response()->json(['error' => $validator->errors()], 400);

        }

    
        $sender_info = [
            'name' => $request->input('name'),
            'phone' => $request->input('phone'),
            'email' => $request->input('email'),
            'body' => $request->input('body'),
        ];

        Mail::send('website.mail.contact', $sender_info, function ($message) {
            $message->from('no-reply@zain-clinic.com');
            $message->to('info@zain-clinic.com');
            $message->subject('Contact Form Message');
        });


        return response()->json(['success' => __('website.contact.sent')],200);

    }
}
