<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\PatientNotification;
use Illuminate\Http\Request;
use Laravel\Sanctum\PersonalAccessToken;

class PatientNotifications extends Controller
{
    public function getPatientNotifications(Request $request, $patient_id)
    {

        $user_id = $this->getUserByToken($request);
        //--- if the sent id doesn't match the id from db, 403 forbidden 

        if ($patient_id != $user_id) {
            return response()->json(['error' => '403'], 403);
        }

        $notifications = PatientNotification::select(['id','title','body','sent_at','read_at'])->where('sent_to',$patient_id)->get();

        return response()->json(['notifications' => $notifications], 200);
       
    }

    public function setAsRead(Request $request, $notification_id)
    {

        $notification = PatientNotification::findOrFail($notification_id);

        $user_id = $this->getUserByToken($request);
        //--- if the sent id doesn't match the id from db, 403 forbidden 

        if ($notification->sent_to != $user_id) {
            return response()->json(['error' => '403'], 403);
        }

        

            if ( $notification->read_at == null){
                $notification->update(['read_at'=>now()]);
            }
            

            return response()->json(['success' => 'success'], 200);
        

        return response()->json(['error' => ['Invalid request']], 400);
    }

    private function getUserByToken(Request $request)
    {
        //--- Get the token from request
        $header = $request->header('authorization');

        $token = str_replace('|', '', strstr($header, '|'));

        //--- Get the user id should be using this token
        $hashedToken = hash('sha256', $token);

        $db_token = PersonalAccessToken::where('token', $hashedToken)->first();

        $user = $db_token->tokenable;

        return $user->id;
    }
}
