<?php

namespace App\View\Components\Admin\Table;

use Illuminate\View\Component;


class Table extends Component
{
    public $baseLink; // base route for ajax calls

    public $rows; // database rows (data to be shown)

    public array $columns; // table header columns

    public int $first_index; // rows index start

    public $pagination; // pagination links

    public array $actionButtons;

    public $groupButtons;

    
    /**
     * Create a new component instance.
     *
     * @return void
     */
    public function __construct( $rows, array $columns, $baseLink, $actionButtons = ['edit'], $groupButtons = null)
    {
        // Table Header Columns
        $this->columns = $columns;

        // Action Buttons
        $this->actionButtons = $actionButtons;

        // Group Buttons
        $this->groupButtons = $groupButtons;

        // Base link
        $this->baseLink = $baseLink;


        $this->first_index = 0;

        $this->rows = [];
        
        $rows_array = $rows->toArray();

        if (array_key_exists('data', $rows_array) && !empty(array_filter($rows_array['data']))) {
            // Get rows from query object

            $this->rows = $rows_array['data'];

            // Set the pagination links
            $this->pagination['links'] = $rows->links();

            // Set the pagination message
            $str_format = __('admin/common.pagination');

            $this->first_index = $rows->firstItem();

            $count = $rows->count() + $this->first_index - 1;

            $total = $rows->total();

            $this->pagination['msg'] = sprintf($str_format, $this->first_index, $count, $total);
        }        
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        return view('components.admin.table.table');
    }
}
