<div class="col-12 d-flex mb-4 align-items-center">
    @if ($prev_week)
        <div class="mr-5">
            <button type="button" id="previous-week" data-href="{{ $prev_week }}"
                class="calendar-nav btn btn-outline-secondary btn-sm">
                <i class="fas fa-chevron-left"></i>
                {{ __('admin/appointments.btn.prev_week') }}
            </button>
        </div>
    @endif
    <span class="h3 mx-auto"> {{ $date_range_title }}</span>
    @if ($next_week)
        <div class="ml-5">
            <button type="button" id="next-week" data-href="{{ $next_week }}"
                class="calendar-nav btn btn-outline-secondary btn-sm">
                {{ __('admin/appointments.btn.next_week') }}
                <i class="fas fa-chevron-right"></i>
            </button>
        </div>
    @endif
</div>
<div class="col-auto ml-auto mb-3">
    <a href="{{ route('admin.appointments') }}" class="btn btn-secondary">
        <i class="fas fa-undo"></i>
        {{ __('admin/appointments.btn.back') }}
    </a>
    <button type="button" class="btn btn-primary px-5 save-app-btn" title="{{ __('admin/common.buttons.save') }}">
        {{ __('admin/common.buttons.save') }}
    </button>
</div>
<div class="col-12">
    @if ($calendar)
        <input type="hidden" id="ap-date" name="ap-date" value="{{ $selected_date }}">
        <input type="hidden" id="ap-session" name="ap-session" value="{{ $selected_time }}">
        @foreach ($calendar as $day)
            @if (!empty(array_filter($day['sessions'])))
                <div class="card mb-3 w-100">
                    <div class="row no-gutters">
                        <div class="col-auto my-auto text-center px-5">
                            <h5>{{ $day['day'] }}</h5>
                            <span>{{ $day['date'] }}</span>
                        </div>
                        <div class="col">
                            <div class="card-body">
                                <div class="row">
                                    @foreach ($day['sessions'] as $session)
                                        @php $rand = rand(0, 9999); @endphp
                                        <div class="col-2 col-xl-1 mb-3 text-center">
                                            <div class="sam-custom-radio">
                                                <input type="radio" id="appointment-{{ $rand }}"
                                                    name="appointment" data-date="{{ $day['date'] }}"
                                                    data-session="{{ $session }}" @if ($selected_date == $day['date'] && $selected_time == $session) checked="checked" @endif>
                                                <label
                                                    for="appointment-{{ $rand }}">{{ $session }}</label>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        @endforeach
    @endif
</div>
<div class="col-12 col-md-8 col-lg-4 col-xl-3 mx-auto">
    <button type="button" class="btn btn-primary btn-block btn-lg save-app-btn" title="{{ __('admin/common.buttons.save') }}">
        {{ __('admin/common.buttons.save') }}
    </button>
</div>

<div class="modal fade" id="appointment-notes-modal" data-backdrop="static" data-keyboard="false" tabindex="-1"
    aria-labelledby="appointment-notes-modal-label" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="appointment-notes-modal-label">ملاحظات الموعد</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <label for="apointment-note"> يرجى اضافة أي ملاحظات خاصة بالموعد (إن وجد)</label>
                <textarea id="appointment-note" name="appointment-note" class="form-control" rows="10"></textarea>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary mr-auto" data-dismiss="modal"
                    title="{{ __('admin/common.buttons.cancel') }}">{{ __('admin/common.buttons.cancel') }}</button>
                <button data-dismiss="modal" class="btn btn-primary">{{ __('admin/common.buttons.save') }}</button>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {

        $(document).off("click").on('click', '.calendar-nav', function(e) {

            e.preventDefault();

            let href = $(this).attr('data-href');


            $(this).prop('disabled', true);

            $.ajax({
                type: "GET",
                url: href,
                dataType: "html",
                beforeSend: function() {
                    $('#loading-overlay').addClass('is-active');
                },
                error: function(XMLHttpRequest) {
                    alert('error');
                    $('#loading-overlay').removeClass('is-active');
                },
                success: function(data) {
                    $('#sessions-table').html(data);
                },
                complete: function(){
                    $('#loading-overlay').removeClass('is-active');
                    $(this).prop('disabled', false);
                }
            });
        });

        $(document).on('click', 'input[name="appointment"]', function(e) {

            if ($(this).is(':checked')) {

                $('#ap-week').val($(this).attr('data-week'));
                $('#ap-date').val($(this).attr('data-date'));
                $('#ap-session').val($(this).attr('data-session'));
            }
        });

        $(document).on('click','.save-app-btn',function(e){
            
            e.preventDefault();

            $('#appointment-notes-modal').modal('show');

        })

        $('#appointment-notes-modal').on('hidden.bs.modal', function () {
            $('#add-appointment-form').trigger('submit')
        });

        //$(document).on('submit', '#add-appointment-form', function(e) {
        $(document).on('submit', '#add-appointment-form', function(e) {

            e.preventDefault();

            let form = $(this);
            let formData = new FormData(form[0]);
            formData.append('appointment-note', $('#appointment-note').val())
            let url = form.attr('action');

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                error: function(xhr) {

                    let parsed = JSON.parse(xhr.responseText);

                    $('#error-alerts').remove();

                    let html = '<div id="error-alerts" class="col-12">';
                    html +=
                        '<div class="alert alert-danger alert-dismissible fade show" role="alert">';
                    //$.each(parsed.error, function(key, err) {
                    html += '<span>' + parsed.error + '</span></br>';
                    //});
                    html +=
                        '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>';
                    html += '</div>';
                    html += '</div>';

                    $('.content-body').prepend(html);

                    $('html,body').animate({
                        scrollTop: 0
                    }, 'slow');
                }
            });
            $.ajax({
                type: "POST",
                url: url,
                data: formData,
                dataType: 'json',
                contentType: false,
                processData: false,
                cache: false,
                success: function(data) {
                    console.log(data);
                    if (data.success) {
                        window.location.href = "{{ route('admin.appointments') }}";
                    }
                }
            });
            return false;
        });
    });
</script>
