<div class="col-12 pb-3">
    <div class="card w-100 border elevation-0">
        <div class="card-body">
            <div class="d-flex w-100 justify-content-between">
                <small class="mt-3 text-muted">{{ __('admin/complaints.columns.is_resolved') }}:
                    {!! $complaint->getStatus() !!}</small>
                <small class="mt-3 text-muted">{{ __('admin/complaints.columns.complaint_date') }}:
                    {{ $complaint->complaint_date->format('Y-m-d') }}</small>
                <small class="mt-3 text-muted">{{ __('admin/complaints.columns.created_at') }}:
                    {{ $complaint->created_at->format('Y-m-d') }}</small>
            </div>
            <hr>
            <div class="w-100 mt-4">
                <p>{{ $complaint->description }}</p>
            </div>

            <div class="d-flex w-100 justify-content-start pt-2 mt-5 border-top">
                <button type="button" class="btn btn-sm btn-purple" data-toggle="modal"
                    data-target="#patient-info-modal">
                    <i class="fas fa-exclamation-circle"></i>
                    Patient Info
                </button>
                <a href="{{ route('admin.appointments', $patient->id) }}" class="btn btn-sm btn-secondary ml-2"
                    target="_blank">
                    <i class="fas fa-calendar-alt"></i>
                    History
                </a>
                @if ($complaint->attachment)
                    <span class="font-weight-bold my-auto ml-auto mr-3">
                        {{ __('admin/complaints.columns.attachment') }}
                    </span>
                    <a href="{{ route('admin.complaints.download', $complaint->id) }}" class="btn btn-sm btn-info"
                        target="_blank">
                        {{ __('admin/complaints.btn.download') }}
                    </a>
                @endif
            </div>
        </div>
    </div>
</div>
{{-- <div class="col-12 mt-4">
    <div class="card w-100 elevation-0 border">
        <div class="card-body">
            <div class="d-flex w-100 mb-3">
                <h4 class="mr-auto my-auto">{{ __('admin/complaint_actions.title') }}</h4>
                <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#add-complaint-message-modal">
                    <i class="fas fa-plus"></i>
                    {{ __('admin/complaint_actions.add_title') }}
                </button>
            </div>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th class="fit">{{ __('admin/complaint_actions.columns.created_at') }}</th>
                        <th class="fit">{{ __('admin/complaint_actions.columns.physician') }}</th>
                        <th class="text-center">{{ __('admin/complaint_actions.columns.response') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @if ($complaint_actions->count() > 0)
                        @foreach ($complaint_actions as $action)
                            <tr>
                                <td>{{ $action->created_at->format('Y-m-d') }}</td>
                                <td>{{ $action->physician->getFullName() }}</td>
                                <td>{{ $action->response }}</td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="3" class="text-center">{{ __('admin/common.msgs.no_results') }}</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>
    </div>

</div> --}}
<div class="col-12 mt-4">
    <div class="card direct-chat direct-chat-primary">
        <div class="card-header">
            <h3 class="card-title">Direct Chat</h3>

            <div class="card-tools">
                <span title="3 New Messages" class="badge badge-primary">3</span>
                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                    <i class="fas fa-minus"></i>
                </button>
                <button type="button" class="btn btn-tool" title="Contacts" data-widget="chat-pane-toggle">
                    <i class="fas fa-comments"></i>
                </button>
                <button type="button" class="btn btn-tool" data-card-widget="remove">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
        <!-- /.card-header -->
        <div class="card-body">
            <!-- Conversations are loaded here -->
            <div class="direct-chat-messages">
                <!-- Message. Default to the left -->
                <div class="direct-chat-msg">
                    <div class="direct-chat-infos clearfix">
                        <span class="direct-chat-name float-left">Alexander Pierce</span>
                        <span class="direct-chat-timestamp float-right">23 Jan 2:00 pm</span>
                    </div>
                    <!-- /.direct-chat-infos -->
                    <img class="direct-chat-img" src="dist/img/user1-128x128.jpg" alt="message user image">
                    <!-- /.direct-chat-img -->
                    <div class="direct-chat-text">
                        Is this template really for free? That's unbelievable!
                    </div>
                    <!-- /.direct-chat-text -->
                </div>
                <!-- /.direct-chat-msg -->

                <!-- Message to the right -->
                <div class="direct-chat-msg right">
                    <div class="direct-chat-infos clearfix">
                        <span class="direct-chat-name float-right">Sarah Bullock</span>
                        <span class="direct-chat-timestamp float-left">23 Jan 2:05 pm</span>
                    </div>
                    <!-- /.direct-chat-infos -->
                    <img class="direct-chat-img" src="dist/img/user3-128x128.jpg" alt="message user image">
                    <!-- /.direct-chat-img -->
                    <div class="direct-chat-text">
                        You better believe it!
                    </div>
                    <!-- /.direct-chat-text -->
                </div>
                <!-- /.direct-chat-msg -->

                <!-- Message. Default to the left -->
                <div class="direct-chat-msg">
                    <div class="direct-chat-infos clearfix">
                        <span class="direct-chat-name float-left">Alexander Pierce</span>
                        <span class="direct-chat-timestamp float-right">23 Jan 5:37 pm</span>
                    </div>
                    <!-- /.direct-chat-infos -->
                    <img class="direct-chat-img" src="dist/img/user1-128x128.jpg" alt="message user image">
                    <!-- /.direct-chat-img -->
                    <div class="direct-chat-text">
                        Working with AdminLTE on a great new app! Wanna join?
                    </div>
                    <!-- /.direct-chat-text -->
                </div>
                <!-- /.direct-chat-msg -->

                <!-- Message to the right -->
                <div class="direct-chat-msg right">
                    <div class="direct-chat-infos clearfix">
                        <span class="direct-chat-name float-right">Sarah Bullock</span>
                        <span class="direct-chat-timestamp float-left">23 Jan 6:10 pm</span>
                    </div>
                    <!-- /.direct-chat-infos -->
                    <img class="direct-chat-img" src="dist/img/user3-128x128.jpg" alt="message user image">
                    <!-- /.direct-chat-img -->
                    <div class="direct-chat-text">
                        I would love to.
                    </div>
                    <!-- /.direct-chat-text -->
                </div>
                <!-- /.direct-chat-msg -->

            </div>
            <!--/.direct-chat-messages-->

            <!-- Contacts are loaded here -->
            <div class="direct-chat-contacts">
                <ul class="contacts-list">
                    <li>
                        <a href="#">
                            <img class="contacts-list-img" src="dist/img/user1-128x128.jpg" alt="User Avatar">

                            <div class="contacts-list-info">
                                <span class="contacts-list-name">
                                    Count Dracula
                                    <small class="contacts-list-date float-right">2/28/2015</small>
                                </span>
                                <span class="contacts-list-msg">How have you been? I was...</span>
                            </div>
                            <!-- /.contacts-list-info -->
                        </a>
                    </li>
                    <!-- End Contact Item -->
                    <li>
                        <a href="#">
                            <img class="contacts-list-img" src="dist/img/user7-128x128.jpg" alt="User Avatar">

                            <div class="contacts-list-info">
                                <span class="contacts-list-name">
                                    Sarah Doe
                                    <small class="contacts-list-date float-right">2/23/2015</small>
                                </span>
                                <span class="contacts-list-msg">I will be waiting for...</span>
                            </div>
                            <!-- /.contacts-list-info -->
                        </a>
                    </li>
                    <!-- End Contact Item -->
                    <li>
                        <a href="#">
                            <img class="contacts-list-img" src="dist/img/user3-128x128.jpg" alt="User Avatar">

                            <div class="contacts-list-info">
                                <span class="contacts-list-name">
                                    Nadia Jolie
                                    <small class="contacts-list-date float-right">2/20/2015</small>
                                </span>
                                <span class="contacts-list-msg">I'll call you back at...</span>
                            </div>
                            <!-- /.contacts-list-info -->
                        </a>
                    </li>
                    <!-- End Contact Item -->
                    <li>
                        <a href="#">
                            <img class="contacts-list-img" src="dist/img/user5-128x128.jpg" alt="User Avatar">

                            <div class="contacts-list-info">
                                <span class="contacts-list-name">
                                    Nora S. Vans
                                    <small class="contacts-list-date float-right">2/10/2015</small>
                                </span>
                                <span class="contacts-list-msg">Where is your new...</span>
                            </div>
                            <!-- /.contacts-list-info -->
                        </a>
                    </li>
                    <!-- End Contact Item -->
                    <li>
                        <a href="#">
                            <img class="contacts-list-img" src="dist/img/user6-128x128.jpg" alt="User Avatar">

                            <div class="contacts-list-info">
                                <span class="contacts-list-name">
                                    John K.
                                    <small class="contacts-list-date float-right">1/27/2015</small>
                                </span>
                                <span class="contacts-list-msg">Can I take a look at...</span>
                            </div>
                            <!-- /.contacts-list-info -->
                        </a>
                    </li>
                    <!-- End Contact Item -->
                    <li>
                        <a href="#">
                            <img class="contacts-list-img" src="dist/img/user8-128x128.jpg" alt="User Avatar">

                            <div class="contacts-list-info">
                                <span class="contacts-list-name">
                                    Kenneth M.
                                    <small class="contacts-list-date float-right">1/4/2015</small>
                                </span>
                                <span class="contacts-list-msg">Never mind I found...</span>
                            </div>
                            <!-- /.contacts-list-info -->
                        </a>
                    </li>
                    <!-- End Contact Item -->
                </ul>
                <!-- /.contacts-list -->
            </div>
            <!-- /.direct-chat-pane -->
        </div>
        <!-- /.card-body -->
        <div class="card-footer">
            <form action="#" method="post">
                <div class="input-group">
                    <input type="text" name="message" placeholder="Type Message ..." class="form-control">
                    <span class="input-group-append">
                        <button type="button" class="btn btn-primary">Send</button>
                    </span>
                </div>
            </form>
        </div>
        <!-- /.card-footer-->
    </div>
</div>






<div class="modal fade" id="patient-info-modal" data-backdrop="static" data-keyboard="false" tabindex="-1"
    aria-labelledby="patient-info-modal-label" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="patient-info-modal-label">{{ $patient->getFullName() }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="card w-100 elevation-0 mb-0">
                    <div class="card-body">
                        <table class="table table-borderless">
                            <tbody>
                                <tr>
                                    <td>
                                        <span class="font-weight-bold mr-2">
                                            {{ __('admin/patients.info_cards.full_name') }}
                                        </span>
                                    </td>
                                    <td>
                                        <span>{{ $patient->getFullName() }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <span class="font-weight-bold mr-2">
                                            {{ __('admin/patients.info_cards.age') }}
                                        </span>
                                    </td>
                                    <td>
                                        <span>{{ $patient->getAge() }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <span class="font-weight-bold mr-2">
                                            {{ __('admin/patients.info_cards.gender') }}
                                        </span>
                                    </td>
                                    <td>
                                        <span>{{ $patient->getGender() }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <span class="font-weight-bold mr-2">
                                            {{ __('admin/patients.info_cards.region') }}
                                        </span>
                                    </td>
                                    <td>
                                        <span>{{ $patient->region->region }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <span class="font-weight-bold mr-2">
                                            {{ __('admin/patients.info_cards.address') }}
                                        </span>
                                    </td>
                                    <td>
                                        <span>{{ $patient->address }}</span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-sm"
                    data-dismiss="modal">{{ __('admin/common.buttons.close') }}</button>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="add-complaint-message-modal" data-backdrop="static" data-keyboard="false" tabindex="-1"
    aria-labelledby="add-complaint-message-modal-label" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="add-complaint-message-modal-label">
                    {{ __('admin/complaint_actions.add_title') }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="modal-alerts"></div>
                <form action="{{ route('admin.complaints.save_response', $complaint->id) }}" method="POST"
                    enctype="multipart/form-data">
                    @csrf
                    <div class="form-group">
                        <label for="description" class="col-form-label required">
                            {{ __('admin/complaints.form.description') }}
                        </label>
                        <textarea class="form-control" rows="10" name="description"
                            id="description">{{ old('description') }}</textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary"
                    data-dismiss="modal">{{ __('admin/common.buttons.close') }}</button>
                <button type="button"
                    class="btn btn-primary btn-save">{{ __('admin/common.buttons.save') }}</button>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function() {
            $('#add-complaint-message-modal .btn-save').on('click', function(e) {

                e.preventDefault();

                var formData = $('#add-complaint-message-modal form').serialize();

                $.ajax({
                    type: "POST",
                    url: "{{ route('admin.complaints.save_response', $complaint->id) }}",
                    data: formData,
                    dataType: "json",
                    cache: false,
                    processData: false,

                    error: function(XMLHttpRequest) {

                        let parsed = JSON.parse(XMLHttpRequest.responseText);

                        if (parsed.errors) {
                            let html = '<div class="alert alert-danger" role="alert">';

                            $.each(parsed.errors.description, function(index, value) {
                                html += value + '</br>';
                            });

                            html += '</div>';

                            $('#add-complaint-message-modal .modal-alerts').html(html);
                        }
                    },

                    success: function(response) {

                        let parsed = JSON.parse(response);

                        $('#add-complaint-message-modal .modal-alerts').html(response.success);

                        setTimeout(function() {
                            $('#add-complaint-message-modal').modal('hide');
                        }, 2000);
                    }
                });
            });

            $('#add-complaint-message-modal').on('hidden.bs.modal', function(event) {
                location.reload();
            });
        });
    </script>
</div>
