<div class="card text-dark border-0 elevation-0">
    <div class="card-body pt-5">
        @if ($comments->count())
            @foreach ($comments as $comment)
                <div class="pt-3">
                    <h6 class="mb-1">{{ $comment->user->full_name }}</h6>
                    <div class="d-flex align-items-center mb-4">
                        <p class="mb-0 text-sm text-muted">
                            {{ $comment->comment_time }}
                        </p>
                    </div>
                    <p class="mb-0">
                        {{ $comment->comment }}
                    </p>
                </div>
                <hr class="mb-3">
            @endforeach
        @else
            <div class="w-100 text-center">
                <span>{{ __('admin/complaint_comments.no_comments') }}</span>
            </div>
        @endif
    </div>

    <div class="card-body mt-3">
        <form action="{{ route('admin.patients.info.comments',$patient)}}" method="post" enctype="multipart/form-data" id="add-comment-form">
            @csrf
            <textarea class="form-control" name="comment" id="comment" rows="5" placeholder="Write a comment...">{{ old('comment') }}</textarea>
            <div class="form-group row">
                <x-admin.form.save-button title="{{ __('admin/common.btn.save') }}" />
            </div>
            <input name="patient-id" type="hidden" value="{{ $patient->id }}">
        </form>
    </div>
</div>