<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ config('app.name') }} | {{ $_page_title }}</title>
    <link rel="stylesheet" href="{{ asset('plugins/fontawesome/css/fontawesome.min.css') }}">
    @if (app()->getLocale() == 'ar')
        <link rel="stylesheet" href="{{ asset('fonts/tajawal/stylesheet.css') }}">
        <link rel="stylesheet" href="{{ asset('admin/css/bootstrap-rtl.css') }}">
    @else
        <link rel="stylesheet" href="{{ asset('fonts/roboto/roboto.css') }}">
        <link rel="stylesheet" href="{{ asset('admin/css/bootstrap.css') }}">
    @endif
    <script src="{{ asset('plugins/jquery/jquery-3.6.0.min.js') }}"></script>
    <style>
        .table th a{
            text-decoration: none;
            color: #000000;
        }
        .table th{
            padding:0.45rem;
        }
        .table td{
            padding:0.35rem;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <div class="col-12 text-center mt-1 mb-2">
                <img src="{{ asset(config('admin.site_logo')) }}" alt="{{ config('app.name') }}" style="width:100px">
            </div>
            <div class="col-12 text-center mt-4">
                <h4>{{ $_page_title }}</h4>
            </div>
            <div class="col-6 my-auto">
                {{ user_name() }}
            </div>
            <div class="col-6 text-right my-auto">
               {{ date('Y-m-d h:i:s A')}}
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-12">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th class="fit text-center">#</th>
                            @foreach ($columns as $col)
                                {!! $col !!}
                            @endforeach
                        </tr>
                    </thead>
                    <tbody class="bg-white">
                        @if ($rows)
                            @foreach ($rows as $index => $row)
                                <tr>
                                    <td class="text-center">{{ $index+1 }}</td>
                                    @foreach ($columns as $key => $col)
                                        <td>{{ $row[$key] }}</td>
                                    @endforeach
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="{{ count($columns) + 1 }}" class="text-center">
                                    {{ __('admin/common.msgs.no_results') }}
                                </td>
                            </tr>
                        @endif
                    </tbody>

                </table>
            </div>
        </div>
    </div>
</body>

</html>
