<div class=" col-12">
    <div class="card bg-white p-3">
        <form action="{{ route('admin.users.update', $user_info->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="row">
                <div class="col">
                    <h4>{{ __('admin/users.text.user_info')}}</h4>
                    <hr>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-6">
                    <label for="edit-first-name"
                        class="col-form-label required">{{ __('admin/users.form.first_name') }}</label>
                    <input type="text" name="first-name" class="form-control" id="edit-first-name"
                        value="{{ old('first-name', $user_info->first_name) }}">
                </div>
                <div class="col-6">
                    <label for="edit-last-name"
                        class="col-form-label required">{{ __('admin/users.form.last_name') }}</label>
                    <input type="text" name="last-name" class="form-control" id="edit-last-name"
                        value="{{ old('last-name', $user_info->last_name) }}">
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-6">
                    <label for="edit-mobile" class="col-form-label required">
                        {{ __('admin/users.form.mobile') }}
                        <small class="muted">(05xxxxxxx)</small>
                    </label>
                    <input type="text" name="mobile" class="form-control" id="edit-mobile"
                        value="{{ old('mobile', $user_info->mobile) }}">
                </div>
                <div class="col-6">
                    <label for="edit-email" class="col-form-label required">{{ __('admin/users.form.email') }}</label>
                    <input type="text" name="email" class="form-control" id="edit-email"
                        value="{{ old('email', $user_info->email) }}">
                </div>
            </div>
            <div class="row mt-4">
                <div class="col">
                    <h4>{{ __('admin/users.text.account_info')}}</h4>
                    <hr>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-md-10 col-lg-6">
                    <label for="edit-role" class="col-form-label required">{{ __('admin/users.form.role') }}</label>
                    <select name="role" class="form-control" id="edit-role">
                        @foreach ($roles as $role)
                            <option value="{{ $role->id }}" {{ old('role',$user_info->role_id) == $role->id ? "selected" : "" }}>{{ $role->role }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-12 col-md-10 col-lg-6" >
                    <label for="branches"
                        class="col-form-label required">{{ __('admin/users.form.branches') }}</label>
                    <select name="branches[]" id="branches" class="form-control selectpicker" multiple>
                        @foreach ($branches as $branch)
                            <option value="{{ $branch->id }}">{{ $branch->branch }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-6">
                    <label for="edit-password" class="col-form-label required">
                        {{ __('admin/users.form.password') }}
                        <small class="muted">(8 chars minimum)</small>
                    </label>
                    <input type="text" name="password" class="form-control" id="edit-password"
                        value="{{ old('password') }}">
                </div>
                <div class="col-6">
                    <label for="edit-cpassword"
                        class="col-form-label required">{{ __('admin/users.form.cpassword') }}</label>
                    <input type="text" name="cpassword" class="form-control" id="edit-cpassword"
                        value="{{ old('cpassword') }}">
                </div>
            </div>
            <div class="form-group">
                <div class="custom-control custom-checkbox mb-2">
                    <input type="checkbox" name="blocked" class="custom-control-input"
                        {{ old('blocked', $user_info->is_blocked) ? 'checked' : '' }} value="1" id="is-blocked">
                    <label class="custom-control-label" for="is-blocked">Account is blocked</label>
                </div>
                <div class="custom-control custom-checkbox mb-2">
                    <input type="checkbox" name="notify" class="custom-control-input"
                        {{ old('notify') ? 'checked' : '' }} value="1" id="notify">
                    <label class="custom-control-label" for="notify">send the user login details via
                        email</label>
                </div>
            </div>
            <div class="form-group row">
                <x-admin.form.save-button title="{{ __('admin/common.btn.save') }}" />
            </div>
        </form>
    </div>

    <script>
        $(document).ready(function(){

            $('#is-physician').change(function() {
                $('#user-services').toggle('fast');
            });

            $('#branches').selectpicker('val', ['{!! $selected_branches !!}']);
            $('#branches').selectpicker('refresh');;
            
        });
    </script>
</div>
