<form action="{{ route('admin.website.save_about') }}" method="POST" enctype="multipart/form-data"
    class="col-12">
    @csrf
    <div class="card card-primary card-outline-tabs">
        <div class="card-header p-0 border-bottom-0">
            <ul class="nav nav-tabs" id="about-us-page-tabs" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="about-us-page-en-tab" data-toggle="pill" href="#about-us-page-en"
                        role="tab" aria-controls="about-us-page-en" aria-selected="true">English</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="about-us-page-ar-tab" data-toggle="pill" href="#about-us-page-ar"
                        role="tab" aria-controls="about-us-page-ar" aria-selected="false">العربية</a>
                </li>
            </ul>
        </div>
        <div class="card-body">
            <div class="tab-content" id="about-us-page-tabsContent">
                <div class="tab-pane fade show active" id="about-us-page-en" role="tabpanel"
                    aria-labelledby="about-us-page-en-tab">
                    <div class="form-group">
                        <label class="required">{{ __('admin/website.about.page_title') }}</label>
                        <input name="page-title[en]" class="form-control" value="{{ old('page-title.en', $about_page_en->title) }}">
                    </div>
                    <div class="form-group mt-4">
                        <label class="required">{{ __('admin/website.about.page_content') }}</label>
                        <textarea class="summernote" name="page-content[en]"></textarea>
                    </div>
                    <div class="form-group row">
                        <x-admin.form.save-button />
                    </div>
                </div>
                <div class="tab-pane fade" id="about-us-page-ar" role="tabpanel"
                    aria-labelledby="about-us-page-ar-tab">
                    <div class="form-group">
                        <label class="required">{{ __('admin/website.about.page_title') }}</label>
                        <input name="page-title[ar]" class="form-control" value="{{ old('page-title.ar', $about_page_ar->title ) }}">
                    </div>
                    <div class="form-group mt-4">
                        <label class="required">{{ __('admin/website.about.page_content') }}</label>
                        <textarea name="page-content[ar]" class="summernote"></textarea>
                    </div>
                    <div class="form-group row">
                        <x-admin.form.save-button />
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<script>
    $(function() {
        $('.summernote').summernote({
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'underline', 'clear']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video', 'hr']],
                ['view', ['codeview']],
            ],
            height: 350,
        })

        $('textarea[name="page-content[en]"]').summernote('pasteHTML',`{!! old('page-content.en', json_decode($about_page_en->content),true) !!}`)
        $('textarea[name="page-content[ar]"]').summernote('pasteHTML',`{!! old('page-content.ar', json_decode($about_page_ar->content),true) !!}`)
    });
</script>
