<form action="{{ route('admin.website.save_treatments') }}" method="POST" enctype="multipart/form-data"
    class="col-12">
    @csrf
    <div class="card card-primary card-outline-tabs">
        <div class="card-header p-0 border-bottom-0">
            <ul class="nav nav-tabs" id="treatments-page-tabs" role="tablist">
                <li class="nav-item">
                    <a class="nav-link active" id="treatments-page-en-tab" data-toggle="pill" href="#treatments-page-en"
                        role="tab" aria-controls="treatments-page-en" aria-selected="true">English</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" id="treatments-page-ar-tab" data-toggle="pill" href="#treatments-page-ar"
                        role="tab" aria-controls="treatments-page-ar" aria-selected="false">العربية</a>
                </li>
            </ul>
        </div>
        <div class="card-body">
            <div class="tab-content" id="treatments-page-tabsContent">
                <div class="tab-pane fade show active" id="treatments-page-en" role="tabpanel"
                    aria-labelledby="treatments-page-en-tab">
                    <div class="form-group">
                        <label class="required">{{ __('admin/website.treatments.page_title') }}</label>
                        <input name="page-title[en]" class="form-control" value="{{ old('page-title.en', $treatments_page_en->title) }}">
                    </div>
                    <div class="form-group mt-4">
                        <label class="required">{{ __('admin/website.treatments.page_content') }}</label>
                        <textarea class="summernote" name="page-content[en]"></textarea>
                    </div>
                    <div class="form-group row">
                        <x-admin.form.save-button />
                    </div>
                </div>
                <div class="tab-pane fade" id="treatments-page-ar" role="tabpanel"
                    aria-labelledby="treatments-page-ar-tab">
                    <div class="form-group">
                        <label class="required">{{ __('admin/website.treatments.page_title') }}</label>
                        <input name="page-title[ar]" class="form-control" value="{{ old('page-title.ar', $treatments_page_ar->title ) }}">
                    </div>
                    <div class="form-group mt-4">
                        <label class="required">{{ __('admin/website.treatments.page_content') }}</label>
                        <textarea name="page-content[ar]" class="summernote"></textarea>
                    </div>
                    <div class="form-group row">
                        <x-admin.form.save-button />
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
<script>
    $(function() {
        $('.summernote').summernote({
            toolbar: [
                ['style', ['style']],
                ['font', ['bold', 'underline', 'clear']],
                ['fontname', ['fontname']],
                ['color', ['color']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['table', ['table']],
                ['insert', ['link', 'picture', 'video', 'hr']],
                ['view', ['codeview']],
            ],
            height: 350,
        })

        $('textarea[name="page-content[en]"]').summernote('pasteHTML',`{!! old('page-content.en', json_decode($treatments_page_en->content),true) !!}`)
        $('textarea[name="page-content[ar]"]').summernote('pasteHTML',`{!! old('page-content.ar', json_decode($treatments_page_ar->content),true) !!}`)
    });
</script>
