<div class="modal fade" id="info-modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
    aria-labelledby="info-modal-label" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content bg-dark">
            <div class="modal-header">
                <h5 class="modal-title" id="info-modal-label">{{ __('admin/appointments.columns.ref_number') }}:
                    {{ $appointment->ref_number }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <table class="table table-borderless text-white">
                    <tbody>
                        <tr>
                            <td>{{ __('admin/appointments.form.treatment') }}</td>
                            <td>{{ $appointment->treatment->treatment }}</td>
                        </tr>
                        <tr>
                            <td>{{ __('admin/appointments.form.day') }}</td>
                            <td>{{ $appointment->appointment_date }}</td>
                        </tr>
                        <tr>
                            <td>{{ __('admin/appointments.form.time') }}</td>
                            <td>{{ date('h:i A', strtotime($appointment->start_time)) }}</td>
                        </tr>
                        <tr>
                            <td>{{ __('admin/branches.form.branch') }}</td>
                            <td>{{ $appointment->branch->branch }}</td>
                        </tr>
                        <tr>
                            <td>{{ __('admin/branches.form.address') }}</td>
                            <td>{{ $appointment->branch->address }}</td>
                        </tr>
                        <tr>
                            <td>{{ __('admin/branches.form.phone') }}</td>
                            <td>{{ $appointment->branch->phone }}</td>
                        </tr>
                        <tr>
                            <td>{{ __('admin/branches.form.mobile') }}</td>
                            <td>{{ $appointment->branch->mobile }}</td>
                        </tr>
                        @if ($appointment->rating)
                            <tr>
                                <td>{{ __('admin/appointments.form.rating') }}</td>
                                <td>

                                    <ul class="list-inline">
                                        @for ($i = 1; $i <= 5; $i++)
                                        @endfor
                                    </ul>

                                </td>
                            </tr>
                        @endif
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-sm"
                    data-bs-dismiss="modal">{{ __('admin/common.buttons.close') }}</button>
            </div>
        </div>
    </div>
</div>
