<div class="row">
    <?php $__currentLoopData = $cards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-12 col-sm-6 col-md-3">
            <div class="info-box">
                <a href="<?php echo e($card['link']); ?>" class="info-box-icon bg-primary elevation-1">
                    <i class="<?php echo e($card['icon']); ?>"></i>
                </a>
                <div class="info-box-content">
                    <span class="info-box-text"><?php echo e($card['title']); ?></span>
                    <span class="info-box-number">
                        <a href="<?php echo e($card['link']); ?>" class="text-dark">
                            <?php echo e($card['count']); ?>

                        </a>
                    </span>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<div class="row">

    <div class="col-12 col-lg-9">
        <div class="card card-outline card-primary">
            <div class="card-header">
                <h4 class="card-title"><?php echo e(__('admin/dashboard.top_ten')); ?></h4>
                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i
                            class="fas fa-minus"></i>
                    </button>
                    <button type="button" class="btn btn-tool" data-card-widget="maximize"><i class="fas fa-expand"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="chart">
                    <canvas id="top_ten_treatments"
                        style="min-height: 350px; height: 350px; max-height: 350px; max-width: 100%;"></canvas>
                </div>
            </div>
        </div>
    </div>
    

    <div class="col-12 col-lg-6">
        <div class="card card-outline card-primary">
            <div class="card-header">
                <h4 class="card-title"><?php echo e(__('admin/dashboard.patients_by_age')); ?></h4>
                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i
                            class="fas fa-minus"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="chart">
                    <canvas id="patient_by_age"
                        style="min-height: 350px; height: 350px; max-height: 350px; max-width: 100%;"></canvas>
                </div>
            </div>
        </div>
    </div>
    <div class="col-12 col-lg-6">
        <div class="card card-outline card-primary">
            <div class="card-header">
                <h4 class="card-title"><?php echo e(__('admin/dashboard.appointments_by_month')); ?></h4>
                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i
                            class="fas fa-minus"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="chart">
                    <canvas id="appointments_by_month"
                        style="min-height: 350px; height: 350px; max-height: 350px; max-width: 100%;"></canvas>
                </div>
            </div>
        </div>
    </div>
    <!-- Pie chart -->
    <div class="col-12 col-lg-3">
        <div class="card card-outline card-primary">
            <div class="card-header">
                <h4 class="card-title"><?php echo e(__('admin/dashboard.patients_by_gender')); ?></h4>
                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i
                            class="fas fa-minus"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="chart">
                    <canvas id="patients_by_gender"
                        style="min-height: 350px; height: 350px; max-height: 350px; max-width: 100%;"></canvas>
                </div>
            </div>
        </div>
    </div>
    <div class="col-12 col-lg-3">
        <div class="card card-outline card-primary">
            <div class="card-header">
                <h4 class="card-title"><?php echo e(__('admin/dashboard.patients_by_region')); ?></h4>
                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i
                            class="fas fa-minus"></i>
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="chart">
                    <canvas id="patients_by_region"
                        style="min-height: 350px; height: 350px; max-height: 350px; max-width: 100%;"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {

        var patientByAgeData = {
            labels: [<?php echo $patient_chart_labels; ?>],
            datasets: [{
                    label: 'Male',
                    backgroundColor: 'rgba(60,141,188,0.9)',
                    borderColor: 'rgba(60,141,188,0.8)',
                    pointRadius: false,
                    pointColor: '#3b8bba',
                    pointStrokeColor: 'rgba(60,141,188,1)',
                    pointHighlightFill: '#fff',
                    pointHighlightStroke: 'rgba(60,141,188,1)',
                    data: [<?php echo $chart_male; ?>]
                },
                {
                    label: 'Female',
                    backgroundColor: '#a3487f',
                    borderColor: 'rgba(239, 41, 164, 0.4)',
                    pointRadius: false,
                    pointColor: 'rgba(239, 41, 164, 0.4)',
                    pointStrokeColor: '#c1c7d1',
                    pointHighlightFill: '#fff',
                    pointHighlightStroke: 'rgba(220,220,220,1)',
                    data: [<?php echo $chart_female; ?>]
                },
            ]
        };

        var patient_by_ageCanvas = $('#patient_by_age').get(0).getContext('2d')
        var patient_by_ageData = $.extend(true, {}, patientByAgeData)
        var temp0 = patientByAgeData.datasets[0]
        var temp1 = patientByAgeData.datasets[1]
        patient_by_ageData.datasets[0] = temp1
        patient_by_ageData.datasets[1] = temp0

        var patient_by_ageOptions = {
            responsive: true,
            maintainAspectRatio: false,
            datasetFill: false
        }

        new Chart(patient_by_ageCanvas, {
            type: 'bar',
            data: patient_by_ageData,
            options: patient_by_ageOptions
        });

        //--------------------------------
        var appointmentByMonthCanvas = $('#appointments_by_month').get(0).getContext('2d')

        var appointmentByMonthData = {
            labels: [<?php echo $month_labels; ?>],
            datasets: [{
                label: 'Appointments Count',
                backgroundColor: '#51a94e ',
                borderColor: '#51a94e',
                pointRadius: true,
                pointHitRadius: 10,
                pointColor: '#3b8bba',
                pointStrokeColor: 'rgba(60,141,188,1)',
                pointHighlightFill: '#fff',
                pointHighlightStroke: 'rgba(60,141,188,1)',
                data: [<?php echo $app_by_month_counts; ?>]
            }, ]
        }

        var appointmentByMonthOptions = {
            maintainAspectRatio: false,
            responsive: true,
            legend: {
                display: false
            },
            scales: {
                xAxes: [{
                    gridLines: {
                        display: false,
                    }
                }],
                yAxes: [{
                    gridLines: {
                        display: false,
                    }
                }]
            }
        }

        new Chart(appointmentByMonthCanvas, {
            type: 'line',
            data: appointmentByMonthData,
            options: appointmentByMonthOptions,

        })

        //--------------------------------
        var patientsByGenderData = {
            labels: [
                'Male',
                'Female',
            ],
            datasets: [{
                data: [<?php echo e($total_male_count); ?>, <?php echo e($total_female_count); ?>],
                backgroundColor: ['rgba(60,141,188,0.9)', '#a3487f'],
            }]
        };
        var patients_by_genderCanvas = $('#patients_by_gender').get(0).getContext('2d')
        var pieData = patientsByGenderData;
        var pieOptions = {
            maintainAspectRatio: false,
            responsive: true,
        }
        //Create pie or douhnut chart
        // You can switch between pie and douhnut using the method below.
        new Chart(patients_by_genderCanvas, {
            type: 'pie',
            data: pieData,
            options: pieOptions
        })

        //----------------------------------------

        var patient_by_region_canvas = $('#patients_by_region').get(0).getContext('2d')
        var patientsByRegionData = {
            labels: [<?php echo $regions; ?>],
            datasets: [{
                data: [<?php echo $patients_by_region_count; ?>],
                backgroundColor: ['#993729', '#0Da65a', '#fA9c12', '#f0df0eb3', '#3D50bc',
                    '#d286de',
                    '#646c1a', '#DA76BA', '#656d76', '#ABFAef', '#4c9dbc', '#343a40'
                ],
            }]
        }
        var patientsByRegionOptions = {
            maintainAspectRatio: false,
            responsive: true,
        }
        //Create pie or douhnut chart
        // You can switch between pie and douhnut using the method below.
        new Chart(patient_by_region_canvas, {
            type: 'doughnut',
            data: patientsByRegionData,
            options: patientsByRegionOptions
        })

        //-----------------------------------
        var topTenTreatmentsData = {
            labels: [<?php echo $treatment_labels; ?>],
            datasets: [{
                    label: '<?php echo e(__("admin/dashboard.apps_count")); ?>',
                    backgroundColor: '#08c5b1',
                    borderColor: 'rgba(60,141,188,0.8)',
                    pointRadius: false,
                    pointColor: '#3b8bba',
                    pointStrokeColor: 'rgba(60,141,188,1)',
                    pointHighlightFill: '#fff',
                    pointHighlightStroke: 'rgba(60,141,188,1)',
                    data: [<?php echo $treatment_counts; ?>]
                },
            ]
        };

        var top_ten_treatmentsCanvas = $('#top_ten_treatments').get(0).getContext('2d')
        var top_ten_treatmentsData = $.extend(true, {}, topTenTreatmentsData)

        var top_ten_treatmentsOptions = {
            responsive: true,
            maintainAspectRatio: false,
            datasetFill: false
        }

        new Chart(top_ten_treatmentsCanvas, {
            type: 'bar',
            data: top_ten_treatmentsData,
            options: top_ten_treatmentsOptions
        });



    });
</script>
<?php /**PATH /home/zainclinic83com/zain.app/resources/views/admin/dashboard/manager.blade.php ENDPATH**/ ?>